/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.TypeElement;
import org.jboss.logging.generator.apt.AbstractGenerator;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.Method;
import org.jboss.logging.generator.util.ElementHelper;

@SupportedOptions(value={"generatedTranslationFilesPath"})
final class TranslationFileGenerator
extends AbstractGenerator {
    public static final String GENERATED_FILES_PATH_OPTION = "generatedTranslationFilesPath";
    public static final String GENERATED_FILE_EXTENSION = ".i18n_locale_COUNTRY_VARIANT.properties";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private final String generatedFilesPath;

    public TranslationFileGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        this.generatedFilesPath = options.get(GENERATED_FILES_PATH_OPTION);
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, MessageInterface messageInterface) {
        if (this.generatedFilesPath != null && element.getKind().isInterface()) {
            String packageName = this.elementUtils().getPackageOf(element).getQualifiedName().toString();
            String relativePath = packageName.replace('.', File.separatorChar);
            String fileName = ElementHelper.getPrimaryClassNamePrefix(element) + GENERATED_FILE_EXTENSION;
            this.generateSkeletalTranslationFile(relativePath, fileName, messageInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void generateSkeletalTranslationFile(String relativePath, String fileName, MessageInterface messageInterface) {
        block15: {
            if (messageInterface == null) {
                throw new NullPointerException("The translations parameter cannot be null");
            }
            File pathFile = new File(this.generatedFilesPath, relativePath);
            pathFile.mkdirs();
            File file = new File(pathFile, fileName);
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(file));
            HashSet<String> processed = new HashSet<String>();
            for (Method method : messageInterface.methods()) {
                if (!processed.add(method.translationKey())) continue;
                writer.write(String.format("# %s", method.message().value()));
                writer.newLine();
                writer.write(String.format("%s=", method.translationKey()));
                writer.newLine();
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                break block15;
            }
            catch (IOException e) {
                this.logger().error((Exception)e, "Cannot close generated skeletal translation file %s", fileName);
            }
            break block15;
            catch (IOException e) {
                try {
                    this.logger().error((Exception)e, "Cannot write generated skeletal translation file %s", fileName);
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e2) {
                        this.logger().error((Exception)e2, "Cannot close generated skeletal translation file %s", fileName);
                    }
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e3) {
                    this.logger().error((Exception)e3, "Cannot close generated skeletal translation file %s", fileName);
                }
            }
        }
    }
}

