/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.jboss.logging.generator.util.TransformationHelper;

public final class ToolLogger {
    private final Messager messager;
    private final boolean isDebugEnabled;

    private ToolLogger(Messager messager, boolean isDebugEnabled) {
        this.messager = messager;
        this.isDebugEnabled = isDebugEnabled;
    }

    public static ToolLogger getLogger(ProcessingEnvironment processingEnv) {
        String debug = processingEnv.getOptions().get("debug");
        boolean isDebugEnabled = Boolean.parseBoolean(debug);
        return new ToolLogger(processingEnv.getMessager(), isDebugEnabled);
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public void note(String messageFormat, Object ... args) {
        this.note(null, messageFormat, args);
    }

    public void note(Element element, String message) {
        this.log(Diagnostic.Kind.NOTE, element, message);
    }

    public void note(Element element, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.NOTE, element, messageFormat, args);
    }

    public void debug(String messageFormat, Object ... args) {
        if (this.isDebugEnabled) {
            this.debug(null, messageFormat, args);
        }
    }

    public void debug(Element element, String message) {
        if (this.isDebugEnabled) {
            this.other(element, message);
        }
    }

    public void debug(Element element, String messageFormat, Object ... args) {
        if (this.isDebugEnabled) {
            this.other(messageFormat, element, args);
        }
    }

    public void warn(String messageFormat, Object ... args) {
        this.warn(null, messageFormat, args);
    }

    public void warn(Element element, String message) {
        this.log(Diagnostic.Kind.WARNING, element, message);
    }

    public void warn(Element element, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.WARNING, element, messageFormat, args);
    }

    public void mandatoryWarning(String messageFormat, Object ... args) {
        this.mandatoryWarning(null, messageFormat, args);
    }

    public void mandatoryWarning(Element element, String message) {
        this.log(Diagnostic.Kind.MANDATORY_WARNING, element, message);
    }

    public void mandatoryWarning(Element element, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.MANDATORY_WARNING, element, messageFormat, args);
    }

    public void error(String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.ERROR, null, messageFormat, args);
    }

    public void error(Element element, String message) {
        this.log(Diagnostic.Kind.ERROR, element, message);
    }

    public void error(Element element, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.ERROR, element, messageFormat, args);
    }

    public void error(Exception exception) {
        this.error(null, exception);
    }

    public void error(Exception exception, Element element, String message) {
        this.log(Diagnostic.Kind.ERROR, element, exception, message);
    }

    public void error(Exception exception, String messageFormat, Object ... args) {
        this.error(null, exception, messageFormat, args);
    }

    public void error(Element element, Exception exception) {
        this.log(Diagnostic.Kind.ERROR, element, exception, null);
    }

    public void error(Element element, Exception exception, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.ERROR, element, exception, messageFormat, args);
    }

    public void other(String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.OTHER, null, messageFormat, args);
    }

    public void other(Element element, String message) {
        this.log(Diagnostic.Kind.OTHER, element, message);
    }

    public void other(Element element, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.OTHER, element, messageFormat, args);
    }

    private void log(Diagnostic.Kind kind, Element element, String message) {
        if (element == null) {
            this.messager.printMessage(kind, message);
        } else {
            this.messager.printMessage(kind, message, element);
        }
    }

    private void log(Diagnostic.Kind kind, Element element, String messageFormat, Object ... args) {
        try {
            String message;
            String string = message = args == null || args.length == 0 ? messageFormat : String.format(messageFormat, args);
            if (element == null) {
                this.messager.printMessage(kind, message);
            } else {
                this.messager.printMessage(kind, message, element);
            }
        }
        catch (Exception e) {
            if (element == null) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Error logging original message: " + messageFormat);
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Error logging original message: " + messageFormat, element);
        }
    }

    private void log(Diagnostic.Kind kind, Element element, Exception exception, String messageFormat, Object ... args) {
        String stringCause = TransformationHelper.stackTraceToString(exception);
        if (messageFormat == null) {
            this.log(kind, element, stringCause);
        } else {
            String messageWithCause = messageFormat.concat(", cause : %s");
            ArrayList<Object> newArgs = new ArrayList<Object>();
            newArgs.addAll(Arrays.asList(args));
            newArgs.add(stringCause);
            this.log(kind, element, messageWithCause, newArgs.toArray());
        }
    }

    private void log(Diagnostic.Kind kind, Element element, Exception exception, String message) {
        String stringCause = TransformationHelper.stackTraceToString(exception);
        if (message == null) {
            this.log(kind, element, stringCause);
        } else {
            String messageWithCause = message.concat(", cause : %s");
            this.log(kind, element, messageWithCause);
        }
    }
}

