/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.generator.apt.ParameterFactory;
import org.jboss.logging.generator.intf.model.Method;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.intf.model.ReturnType;
import org.jboss.logging.generator.util.ElementHelper;
import org.jboss.logging.generator.util.Objects;

final class ThrowableReturnTypeFactory {
    ThrowableReturnTypeFactory() {
    }

    public static ReturnType.ThrowableReturnType of(Elements elements, Types types, TypeMirror returnType, Method messageMethod) {
        AptThrowableReturnType result = new AptThrowableReturnType(elements, types, messageMethod, returnType);
        result.init();
        return result;
    }

    private static class AptThrowableReturnType
    implements ReturnType.ThrowableReturnType {
        private final Elements elements;
        private final Types types;
        private final TypeMirror returnType;
        private final Method messageMethod;
        private boolean defaultConstructor = false;
        private boolean stringConstructor = false;
        private boolean throwableConstructor = false;
        private boolean stringAndThrowableConstructor = false;
        private boolean throwableAndStringConstructor = false;
        private boolean useConstructionParameters = false;
        private final Set<Parameter> constructionParameters;

        private AptThrowableReturnType(Elements elements, Types types, Method messageMethod, TypeMirror returnType) {
            this.elements = elements;
            this.types = types;
            this.returnType = returnType;
            this.messageMethod = messageMethod;
            this.constructionParameters = new LinkedHashSet<Parameter>();
        }

        private void init() {
            if (!this.returnType.getKind().isPrimitive() && this.returnType.getKind() != TypeKind.VOID) {
                Element element = this.types.asElement(this.returnType);
                List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
                for (ExecutableElement constructor : constructors) {
                    if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                    List<? extends VariableElement> params = constructor.getParameters();
                    if (this.messageMethod.constructorParameters().isEmpty()) {
                        switch (params.size()) {
                            case 0: {
                                this.defaultConstructor = true;
                                break;
                            }
                            case 1: {
                                if (ElementHelper.isAssignableFrom(params.get(0).asType(), String.class)) {
                                    this.stringConstructor = true;
                                    break;
                                }
                                if (!ElementHelper.isAssignableFrom(Throwable.class, params.get(0).asType())) break;
                                this.throwableConstructor = true;
                                break;
                            }
                            case 2: {
                                if (ElementHelper.isAssignableFrom(params.get(0).asType(), String.class) && ElementHelper.isAssignableFrom(Throwable.class, params.get(1).asType())) {
                                    this.stringAndThrowableConstructor = true;
                                    break;
                                }
                                if (!ElementHelper.isAssignableFrom(Throwable.class, params.get(0).asType()) || !ElementHelper.isAssignableFrom(params.get(1).asType(), String.class)) break;
                                this.throwableAndStringConstructor = true;
                            }
                        }
                        continue;
                    }
                    Iterator<Parameter> methodParameterIterator = this.messageMethod.constructorParameters().iterator();
                    LinkedHashSet<Parameter> matchedParams = new LinkedHashSet<Parameter>();
                    boolean match = false;
                    boolean causeFound = false;
                    boolean messageFound = false;
                    for (VariableElement variableElement : params) {
                        if (!causeFound && this.messageMethod.hasCause() && ElementHelper.isAssignableFrom(Throwable.class, variableElement.asType())) {
                            causeFound = true;
                            matchedParams.add(this.messageMethod.cause());
                            continue;
                        }
                        if (!messageFound && ElementHelper.isAssignableFrom(variableElement.asType(), String.class)) {
                            messageFound = true;
                            matchedParams.add(ParameterFactory.forMessageMethod(this.messageMethod));
                            continue;
                        }
                        if (methodParameterIterator.hasNext()) {
                            Parameter parameter = methodParameterIterator.next();
                            if (parameter.reference() instanceof VariableElement) {
                                VariableElement refType = (VariableElement)parameter.reference();
                                match = this.types.isAssignable(refType.asType(), variableElement.asType());
                            }
                            if (match) {
                                matchedParams.add(parameter);
                            }
                        }
                        if (match) continue;
                        break;
                    }
                    if (!match) continue;
                    this.useConstructionParameters = true;
                    this.constructionParameters.addAll(matchedParams);
                    break;
                }
            }
        }

        @Override
        public boolean hasDefaultConstructor() {
            return this.defaultConstructor;
        }

        @Override
        public boolean hasStringAndThrowableConstructor() {
            return this.stringAndThrowableConstructor;
        }

        @Override
        public boolean hasStringConstructor() {
            return this.stringConstructor;
        }

        @Override
        public boolean hasThrowableAndStringConstructor() {
            return this.throwableAndStringConstructor;
        }

        @Override
        public boolean hasThrowableConstructor() {
            return this.throwableConstructor;
        }

        @Override
        public boolean useConstructionParameters() {
            return this.useConstructionParameters;
        }

        @Override
        public Set<Parameter> constructionParameters() {
            return this.constructionParameters;
        }

        @Override
        public String name() {
            return ((Object)this.returnType).toString();
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.returnType).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptThrowableReturnType)) {
                return false;
            }
            AptThrowableReturnType other = (AptThrowableReturnType)obj;
            return Objects.areEqual(this.returnType, other.returnType);
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("returnType", this.returnType).add("stringConstructor", this.stringConstructor).add("throwableConstructor", this.throwableConstructor).add("stringAndThrowableConstructor", this.stringAndThrowableConstructor).add("throwableAndStringConstructor", this.throwableAndStringConstructor).toString();
        }

        @Override
        public TypeMirror reference() {
            return this.returnType;
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isAssignable(typeMirror, this.returnType);
        }

        @Override
        public boolean isSubtypeOf(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isSubtype(this.returnType, typeMirror);
        }
    }
}

