/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.generator.apt.ThrowableReturnTypeFactory;
import org.jboss.logging.generator.intf.model.Method;
import org.jboss.logging.generator.intf.model.ReturnType;
import org.jboss.logging.generator.util.Objects;

final class ReturnTypeFactory {
    private ReturnTypeFactory() {
    }

    public static ReturnType of(Elements elements, Types types, TypeMirror returnType, Method messageMethod) {
        if (returnType.getKind() == TypeKind.VOID) {
            return ReturnType.VOID;
        }
        AptReturnType result = new AptReturnType(elements, types, returnType, messageMethod);
        result.init();
        return result;
    }

    private static class AptReturnType
    implements ReturnType {
        private final Elements elements;
        private final Types types;
        private final TypeMirror returnType;
        private final Method messageMethod;
        private ReturnType.ThrowableReturnType throwableReturnType;

        private AptReturnType(Elements elements, Types types, TypeMirror returnType, Method messageMethod) {
            this.elements = elements;
            this.types = types;
            this.returnType = returnType;
            this.messageMethod = messageMethod;
            this.throwableReturnType = null;
        }

        @Override
        public boolean isThrowable() {
            return this.isSubtypeOf(Throwable.class);
        }

        @Override
        public boolean isPrimitive() {
            return this.returnType.getKind().isPrimitive();
        }

        @Override
        public String name() {
            return ((Object)this.returnType).toString();
        }

        @Override
        public ReturnType.ThrowableReturnType throwableReturnType() {
            return this.throwableReturnType;
        }

        private void init() {
            if (this.isThrowable()) {
                this.throwableReturnType = ThrowableReturnTypeFactory.of(this.elements, this.types, this.returnType, this.messageMethod);
            }
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptReturnType)) {
                return false;
            }
            AptReturnType other = (AptReturnType)obj;
            return Objects.areEqual(this.name(), other.name());
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("primitive", this.isPrimitive()).add("throwable", this.isThrowable()).add("throwableReturnType", this.throwableReturnType).toString();
        }

        @Override
        public TypeMirror reference() {
            return this.returnType;
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isAssignable(typeMirror, this.returnType);
        }

        @Override
        public boolean isSubtypeOf(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isSubtype(this.returnType, typeMirror);
        }
    }
}

