/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.generator.Tools;
import org.jboss.logging.generator.intf.model.Method;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.util.Comparison;
import org.jboss.logging.generator.util.ElementHelper;
import org.jboss.logging.generator.util.Objects;

final class ParameterFactory {
    private ParameterFactory() {
    }

    public static Set<Parameter> of(Elements elements, Types types, ExecutableElement method) {
        LinkedHashSet<Parameter> result = new LinkedHashSet<Parameter>();
        List<? extends VariableElement> params = method.getParameters();
        int index = 0;
        for (VariableElement variableElement : params) {
            String qualifiedType;
            String formatClass = null;
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (!annotationType.equals(types.getDeclaredType(elements.getTypeElement(Tools.annotations().formatWith().getName()), new TypeMirror[0]))) continue;
                AnnotationValue value = annotationMirror.getElementValues().values().iterator().next();
                formatClass = ((TypeElement)((DeclaredType)value.getValue()).asElement()).getQualifiedName().toString();
            }
            if (variableElement.asType().getKind().isPrimitive()) {
                qualifiedType = ((Object)variableElement.asType()).toString();
            } else {
                switch (variableElement.asType().getKind()) {
                    case ARRAY: {
                        qualifiedType = ((Object)variableElement.asType()).toString().replace("[]", "");
                        break;
                    }
                    default: {
                        qualifiedType = types.asElement(variableElement.asType()).toString();
                    }
                }
            }
            if (method.isVarArgs()) {
                result.add(new AptParameter(elements, types, qualifiedType, variableElement, formatClass, ++index == params.size()));
                continue;
            }
            result.add(new AptParameter(elements, types, qualifiedType, variableElement, formatClass, false));
        }
        return result;
    }

    public static Parameter forMessageMethod(final Method messageMethod) {
        return new Parameter(){

            @Override
            public boolean isCause() {
                return false;
            }

            @Override
            public boolean isMessage() {
                return true;
            }

            @Override
            public boolean isParam() {
                return false;
            }

            @Override
            public String getFormatterClass() {
                return null;
            }

            @Override
            public Class<?> paramClass() {
                return null;
            }

            @Override
            public String type() {
                return String.class.getName();
            }

            @Override
            public String name() {
                return messageMethod.messageMethodName();
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean isVarArgs() {
                return false;
            }

            public int hashCode() {
                return Objects.HashCodeBuilder.builder().add(this.type()).add(this.name()).toHashCode();
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof AptParameter)) {
                    return false;
                }
                AptParameter other = (AptParameter)obj;
                return Objects.areEqual(this.type(), other.type()) && Objects.areEqual(this.name(), other.name());
            }

            @Override
            public int compareTo(Parameter other) {
                return Comparison.begin().compare((Comparable<?>)((Object)this.type()), (Comparable<?>)((Object)other.type())).compare((Comparable<?>)((Object)this.name()), (Comparable<?>)((Object)other.name())).result();
            }

            public String toString() {
                return Objects.ToStringBuilder.of(this).add("name", this.name()).add("type", this.type()).toString();
            }

            @Override
            public Method reference() {
                return messageMethod;
            }

            @Override
            public boolean isAssignableFrom(Class<?> type) {
                return String.class.isAssignableFrom(type);
            }

            @Override
            public boolean isSubtypeOf(Class<?> type) {
                return type.isAssignableFrom(String.class);
            }
        };
    }

    private static class AptParameter
    implements Parameter {
        private final Types types;
        private final Elements elements;
        private final VariableElement param;
        private final String qualifiedType;
        private final String formatterClass;
        private final Class<?> paramClass;
        private final boolean isParam;
        private final boolean isVarArgs;

        AptParameter(Elements elements, Types types, String qualifiedType, VariableElement param, String formatterClass, boolean isVarArgs) {
            this.elements = elements;
            this.types = types;
            this.qualifiedType = qualifiedType;
            this.param = param;
            this.formatterClass = formatterClass;
            if (ElementHelper.isAnnotatedWith(param, Tools.annotations().param())) {
                this.paramClass = Object.class;
                this.isParam = true;
            } else {
                this.isParam = false;
                this.paramClass = null;
            }
            this.isVarArgs = isVarArgs;
        }

        @Override
        public boolean isCause() {
            return ElementHelper.isAnnotatedWith(this.param, Tools.annotations().cause());
        }

        @Override
        public boolean isMessage() {
            return false;
        }

        @Override
        public boolean isParam() {
            return this.isParam;
        }

        @Override
        public String type() {
            return this.qualifiedType;
        }

        @Override
        public String getFormatterClass() {
            return this.formatterClass;
        }

        @Override
        public String name() {
            return this.param.getSimpleName().toString();
        }

        @Override
        public boolean isArray() {
            return this.param.asType().getKind() == TypeKind.ARRAY;
        }

        @Override
        public boolean isPrimitive() {
            return this.param.asType().getKind().isPrimitive();
        }

        @Override
        public boolean isVarArgs() {
            return this.isVarArgs;
        }

        @Override
        public Class<?> paramClass() {
            return this.paramClass;
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.qualifiedType).add(this.param).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptParameter)) {
                return false;
            }
            AptParameter other = (AptParameter)obj;
            return Objects.areEqual(this.param, other.param) && Objects.areEqual(this.qualifiedType, other.qualifiedType);
        }

        @Override
        public int compareTo(Parameter other) {
            return Comparison.begin().compare((Comparable<?>)((Object)this.type()), (Comparable<?>)((Object)other.type())).compare((Comparable<?>)((Object)this.name()), (Comparable<?>)((Object)other.name())).result();
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("type", this.type()).toString();
        }

        @Override
        public VariableElement reference() {
            return this.param;
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isAssignable(typeMirror, this.param.asType());
        }

        @Override
        public boolean isSubtypeOf(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isSubtype(this.param.asType(), typeMirror);
        }
    }
}

