/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.generator.Tools;
import org.jboss.logging.generator.apt.MessageMethodBuilder;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.Method;
import org.jboss.logging.generator.util.ElementHelper;
import org.jboss.logging.generator.util.Objects;

public final class MessageInterfaceFactory {
    private static volatile BasicLoggerInterface BASIC_LOGGER_INTERFACE = null;
    private static final Object LOCK = new Object();

    private MessageInterfaceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageInterface of(ProcessingEnvironment processingEnvironment, TypeElement interfaceElement) {
        Types types = processingEnvironment.getTypeUtils();
        Elements elements = processingEnvironment.getElementUtils();
        if (types.isSameType(interfaceElement.asType(), elements.getTypeElement(Tools.loggers().basicLoggerClass().getName()).asType())) {
            BasicLoggerInterface result = BASIC_LOGGER_INTERFACE;
            if (result == null) {
                Object object = LOCK;
                synchronized (object) {
                    result = BASIC_LOGGER_INTERFACE;
                    if (result == null) {
                        result = BASIC_LOGGER_INTERFACE = BasicLoggerInterface.of(elements, types);
                    }
                }
            }
            return result;
        }
        AptMessageInterface result = new AptMessageInterface(interfaceElement, types, elements);
        result.init();
        for (TypeMirror typeMirror : interfaceElement.getInterfaces()) {
            MessageInterface extended = MessageInterfaceFactory.of(processingEnvironment, (TypeElement)types.asElement(typeMirror));
            result.extendedInterfaces.add(extended);
            result.extendedInterfaces.addAll(extended.extendedInterfaces());
        }
        return result;
    }

    private static class BasicLoggerInterface
    implements MessageInterface {
        private final TypeElement basicLogger;
        private final Elements elements;
        private final Types types;
        private final Set<Method> methods;

        private BasicLoggerInterface(Elements elements, Types types) {
            this.elements = elements;
            this.types = types;
            this.methods = new HashSet<Method>();
            this.basicLogger = elements.getTypeElement(Tools.loggers().basicLoggerClass().getName());
        }

        static BasicLoggerInterface of(Elements elements, Types types) {
            BasicLoggerInterface result = new BasicLoggerInterface(elements, types);
            result.init();
            return result;
        }

        private void init() {
            MessageMethodBuilder builder = MessageMethodBuilder.create(this.elements, this.types);
            List<ExecutableElement> methods = ElementFilter.methodsIn(this.basicLogger.getEnclosedElements());
            for (ExecutableElement method : methods) {
                builder.add(method);
            }
            Set<? extends Method> m = builder.build();
            this.methods.addAll(m);
        }

        @Override
        public Set<MessageInterface> extendedInterfaces() {
            return Collections.emptySet();
        }

        @Override
        public Collection<Method> methods() {
            return this.methods;
        }

        @Override
        public String projectCode() {
            return null;
        }

        @Override
        public String name() {
            return Tools.loggers().basicLoggerClass().getName();
        }

        @Override
        public String packageName() {
            return Tools.loggers().basicLoggerClass().getPackage().getName();
        }

        @Override
        public String simpleName() {
            return Tools.loggers().basicLoggerClass().getSimpleName();
        }

        @Override
        public boolean isMessageLogger() {
            return false;
        }

        @Override
        public boolean isMessageBundle() {
            return false;
        }

        @Override
        public boolean isBasicLogger() {
            return true;
        }

        @Override
        public TypeElement reference() {
            return this.basicLogger;
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isAssignable(typeMirror, this.basicLogger.asType());
        }

        @Override
        public boolean isSubtypeOf(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isSubtype(this.basicLogger.asType(), typeMirror);
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptMessageInterface)) {
                return false;
            }
            AptMessageInterface other = (AptMessageInterface)obj;
            return Objects.areEqual(this.name(), other.name());
        }

        @Override
        public int compareTo(MessageInterface o) {
            return this.name().compareTo(o.name());
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add(this.name()).toString();
        }
    }

    private static class AptMessageInterface
    implements MessageInterface {
        private final TypeElement interfaceElement;
        private final Types types;
        private final Elements elements;
        private final Set<MessageInterface> extendedInterfaces;
        private final List<Method> methods;
        private String projectCode;
        private String packageName;
        private String simpleName;
        private String qualifiedName;

        private AptMessageInterface(TypeElement interfaceElement, Types types, Elements elements) {
            this.interfaceElement = interfaceElement;
            this.types = types;
            this.elements = elements;
            this.methods = new LinkedList<Method>();
            this.extendedInterfaces = new LinkedHashSet<MessageInterface>();
        }

        @Override
        public Set<MessageInterface> extendedInterfaces() {
            return Collections.unmodifiableSet(this.extendedInterfaces);
        }

        @Override
        public Collection<Method> methods() {
            return this.methods;
        }

        @Override
        public String projectCode() {
            return this.projectCode;
        }

        @Override
        public String name() {
            return this.qualifiedName;
        }

        @Override
        public String packageName() {
            return this.packageName;
        }

        @Override
        public String simpleName() {
            return this.simpleName;
        }

        @Override
        public boolean isMessageLogger() {
            return ElementHelper.isAnnotatedWith(this.interfaceElement, Tools.annotations().messageLogger());
        }

        @Override
        public boolean isMessageBundle() {
            return ElementHelper.isAnnotatedWith(this.interfaceElement, Tools.annotations().messageBundle());
        }

        @Override
        public boolean isBasicLogger() {
            return false;
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptMessageInterface)) {
                return false;
            }
            AptMessageInterface other = (AptMessageInterface)obj;
            return Objects.areEqual(this.name(), other.name());
        }

        @Override
        public int compareTo(MessageInterface o) {
            return this.name().compareTo(o.name());
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add(this.qualifiedName).toString();
        }

        private void init() {
            List<ExecutableElement> methods = ElementFilter.methodsIn(this.interfaceElement.getEnclosedElements());
            MessageMethodBuilder builder = MessageMethodBuilder.create(this.elements, this.types);
            for (ExecutableElement param : methods) {
                builder.add(param);
            }
            Set<? extends Method> m = builder.build();
            if (m != null) {
                this.methods.addAll(m);
            }
            this.projectCode = Tools.aptHelper().projectCode(this.interfaceElement);
            this.qualifiedName = this.elements.getBinaryName(this.interfaceElement).toString();
            int lastDot = this.qualifiedName.lastIndexOf(".");
            if (lastDot > 0) {
                this.packageName = this.qualifiedName.substring(0, lastDot);
                this.simpleName = this.qualifiedName.substring(lastDot + 1);
            } else {
                this.packageName = null;
                this.simpleName = this.qualifiedName;
            }
        }

        @Override
        public TypeElement reference() {
            return this.interfaceElement;
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isAssignable(typeMirror, this.interfaceElement.asType());
        }

        @Override
        public boolean isSubtypeOf(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isSubtype(this.interfaceElement.asType(), typeMirror);
        }
    }
}

