/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.dependency;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;

/**
 * ControllerContext for beans that need to interact with web beans.
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class WeldKernelControllerContext extends AbstractKernelControllerContext
{
   WeldInjector<?> webBeansInjector;
   BeanManager manager;
   AnnotatedType<?> type;
   
   
   /**
    * Create an abstract controller context
    *
    * @param info     the bean info
    * @param metaData the meta data
    * @param target   any target object
    * @param manager the bean manager to use
    */
   public WeldKernelControllerContext(BeanInfo info, BeanMetaData metaData, Object target, BeanManager manager)
   {
      super(info, metaData, WeldKernelControllerContextActions.getInstance(), target);
      if (manager == null)
         throw new IllegalArgumentException("Null manager");
      this.manager = manager;
   }

   @Override
   public void setController(Controller controller)
   {
      WeldControllerInitializer.initializeController(controller);
      super.setController(controller);
   }
   
   /**
    * Gets the beanmanager
    * 
    * @return the bean manager 
    */
   public BeanManager getManager()
   {
      return manager;
   }
   
   /**
    * Sets the web beans injector
    * 
    * @param webBeansInjector the web beans injector 
    */
   public void setWeldInjector(WeldInjector<?> webBeansInjector)
   {
      this.webBeansInjector = webBeansInjector;
   }
   
   /**
    * Gets the web beans injector
    * 
    * @return the web beans injector 
    */
   public WeldInjector<?> getWeldInjector()
   {
      return webBeansInjector;
   }
}
