/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.tracker.ContextRegistry;
import org.jboss.kernel.Kernel;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceCreator;
import org.jboss.system.ServiceInstance;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.microcontainer.ServiceControllerContext;
import org.jboss.system.microcontainer.ServiceControllerContextAction;

public class InstantiateAction
extends ServiceControllerContextAction {
    protected ContextRegistry getRegistry(ServiceControllerContext context) {
        ServiceController serviceController = context.getServiceController();
        Kernel kernel = serviceController.getKernel();
        return kernel.getController();
    }

    public void installAction(ServiceControllerContext context) throws Throwable {
        MBeanServer server = context.getServiceController().getMBeanServer();
        ObjectName objectName = context.getObjectName();
        ServiceMetaData metaData = context.getServiceMetaData();
        Object mbean = context.getTarget();
        ServiceInstance instance = ServiceCreator.install(server, objectName, metaData, mbean);
        context.setTarget(instance.getResource());
        ContextRegistry registry = this.getRegistry(context);
        registry.addInstantiatedContext((ControllerContext)context);
    }

    public void uninstallAction(ServiceControllerContext context) {
        ContextRegistry registry = this.getRegistry(context);
        registry.removeInstantiatedContext((ControllerContext)context);
        MBeanServer server = context.getServiceController().getMBeanServer();
        ObjectName objectName = context.getObjectName();
        ServiceCreator.uninstall(server, objectName);
        ServiceMetaData metaData = context.getServiceMetaData();
        if (metaData != null) {
            context.setTarget(null);
        }
    }
}

