/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.List;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.microcontainer.beans.BindingEntry;
import org.jboss.aop.microcontainer.beans.InterceptorEntry;
import org.jboss.aop.microcontainer.beans.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackEntry
extends BindingEntry {
    Stack stack;
    List<InterceptorEntry> advices;
    InterceptorFactory[] factories;

    public Stack getStack() {
        return this.stack;
    }

    public void setStack(Stack stack) {
        this.stack = stack;
    }

    public List<InterceptorEntry> getAdvices() {
        return this.advices;
    }

    @Override
    public InterceptorFactory[] getInterceptorFactories() {
        return this.factories;
    }

    @Override
    public void start() {
        this.validateManagerAndBinding();
        if (this.stack == null) {
            throw new IllegalArgumentException("Null stack");
        }
        this.advices = this.stack.getClonedAdvices(this.binding);
        if (this.advices == null) {
            throw new IllegalArgumentException("Null advices");
        }
        this.factories = new InterceptorFactory[this.advices.size()];
        int i = 0;
        for (InterceptorEntry entry : this.advices) {
            entry.start();
            this.factories[i++] = entry.getInterceptorFactory();
        }
    }

    @Override
    public void stop() {
        this.advices = null;
        this.factories = null;
    }
}

