/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.microcontainer.beans.BeanFactoryAwareAspectFactory;
import org.jboss.aop.microcontainer.beans.GenericBeanAspectFactory;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.logging.Logger;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Element;

public class DelegatingBeanAspectFactory
implements AspectFactory,
KernelControllerContextAware,
BeanFactoryAwareAspectFactory {
    private static final Logger log = Logger.getLogger(GenericBeanAspectFactory.class);
    protected BeanFactory factory;
    protected String name;
    protected Element element;
    protected KernelControllerContext context;
    protected AspectFactory aspectFactory;

    public DelegatingBeanAspectFactory(String name, BeanFactory factory, Element element) {
        this.name = name;
        this.factory = factory;
        this.element = element;
    }

    public void setKernelControllerContext(KernelControllerContext context) {
        this.context = context;
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = null;
    }

    public void setBeanFactory(BeanFactory factory) {
        this.factory = factory;
    }

    public String getName() {
        return this.name;
    }

    public Object createPerVM() {
        AspectFactory factory = this.doCreate();
        return factory.createPerVM();
    }

    public Object createPerClass(Advisor advisor) {
        AspectFactory factory = this.doCreate();
        return factory.createPerClass(advisor);
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        AspectFactory factory = this.doCreate();
        return factory.createPerInstance(advisor, instanceAdvisor);
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        AspectFactory factory = this.doCreate();
        return factory.createPerJoinpoint(advisor, jp);
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        AspectFactory factory = this.doCreate();
        return factory.createPerJoinpoint(advisor, instanceAdvisor, jp);
    }

    protected synchronized AspectFactory doCreate() {
        try {
            if (this.aspectFactory == null) {
                log.debugf("Creating advice %1s", new Object[]{this.name});
                PushedClassLoaderMetaData pcmd = null;
                if (((GenericBeanFactory)this.factory).getClassLoader() == null) {
                    pcmd = new PushedClassLoaderMetaData();
                    ((GenericBeanFactory)this.factory).setClassLoader((ClassLoaderMetaData)pcmd);
                }
                Object object = null;
                try {
                    object = this.factory.createBean();
                }
                catch (Throwable t) {
                    if (pcmd == null) {
                        throw new RuntimeException(t);
                    }
                    pcmd.setLookAtContext(true);
                    object = this.factory.createBean();
                }
                this.aspectFactory = (AspectFactory)object;
                if (this.aspectFactory instanceof XmlLoadable) {
                    ((XmlLoadable)this.aspectFactory).importXml(this.element);
                }
            }
            return this.aspectFactory;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private class PushedClassLoaderMetaData
    extends AbstractClassLoaderMetaData {
        private static final long serialVersionUID = 1L;
        boolean lookAtContext;

        private PushedClassLoaderMetaData() {
        }

        void setLookAtContext(boolean look) {
            this.lookAtContext = look;
        }

        public ValueMetaData getClassLoader() {
            ClassLoader loader = null;
            if (this.lookAtContext && DelegatingBeanAspectFactory.this.context != null) {
                try {
                    loader = DelegatingBeanAspectFactory.this.context.getClassLoader();
                }
                catch (Throwable t) {
                    this.log.trace((Object)("Unable to retrieve classloader from " + DelegatingBeanAspectFactory.this.context));
                }
                if (loader == null) {
                    try {
                        loader = Configurator.getClassLoader((ClassLoaderMetaData)((GenericBeanFactory)DelegatingBeanAspectFactory.this.factory).getClassLoader());
                    }
                    catch (Throwable e) {
                        this.log.trace((Object)("Unable to retrieve classloader from " + DelegatingBeanAspectFactory.this.factory));
                    }
                }
            }
            return loader != null ? new AbstractValueMetaData(loader) : null;
        }
    }
}

