/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.kernel.spi.config.KernelConfigurator;

public class ClassLoaderAwareGenericBeanFactory
extends GenericBeanFactory {
    private ThreadLocal<ClassLoader> pushedLoader = new ThreadLocal();

    public ClassLoaderAwareGenericBeanFactory(KernelConfigurator configurator) {
        super(configurator);
    }

    public void pushLoader(ClassLoader loader) {
        this.pushedLoader.set(loader);
    }

    public void popLoader() {
        this.pushedLoader.set(null);
    }

    public Object createBean() throws Throwable {
        ClassLoader loader = this.pushedLoader.get();
        if (loader == null) {
            return super.createBean();
        }
        return super.createBean(loader);
    }
}

