package org.jboss.jsr299.tck.spi;

import java.lang.annotation.Annotation;
import java.util.List;

import javax.inject.manager.Manager;

/**
 * This interface provides operations relating to a Manager.
 * 
 * The TCK porting package must provide an implementation of this interface which is 
 * suitable for the target implementation. 
 * 
 * @author Shane Bryzak
 */
public interface Managers
{   
   
   public static final String PROPERTY_NAME = Managers.class.getName();
   
   /**
    * Get a new Manager instance
    * 
    * @return the Manager 
    */
   public Manager getManager();
   
   /**
    * Returns a list of the enabled deployment types for the current manager
    * 
    * @return
    */
   List<Class<? extends Annotation>> getEnabledDeploymentTypes();
   
}
