package org.jboss.jsr299.tck.spi;

import java.io.IOException;
import java.io.InputStream;

import org.jboss.jsr299.tck.api.DeploymentException;

/**
 * Incontainer mode deployment related operations
 * 
 * The TCK porting package must provide an implementation of this interface
 * which is suitable for the target implementation and application server
 * 
 * @author Pete Muir
 * 
 */
public interface Containers
{
   
   public static final String PROPERTY_NAME = Containers.class.getName();
   
   /**
    * The war/ear to deploy to the container, it should be read using a
    * JarInputStream.
    * 
    * For a successful deployment, a symmetric {@link #undeploy(String)} will be
    * called.
    * 
    * @see #undeploy(String)
    * 
    * @param archive
    *           the archive
    * @param name
    *           the name the TCK uses to refer to this archive, unique within
    *           this tck run
    * @throws DeploymentException
    *            if any exceptions are encountered during deployment, they
    *            should be rethrown wrapped in a {@link DeploymentException}.
    *            Note that the TCK checks deployment exceptions.
    * @throws IOException
    *            if any communication problems with the server occur during
    *            deployment. These will cause the test suite to fail.
    */
   public void deploy(InputStream archive, String name) throws DeploymentException, IOException;
   
   /**
    * Undeploy the war/ear from the container.
    * 
    * @see #deploy(InputStream, String)
    * 
    * @param name
    *           the name the TCK uses to refer to this archive, unique within
    *           this tck run
    * @throws IOException
    *            if any communication problems with the server occur during
    *            deployment. These will cause the test suite to fail.
    */
   public void undeploy(String name) throws IOException;
   
   /**
    * Called before the TCK starts executing the testsuite, but after the suite
    * has been configured.
    * 
    * A TCK suite lifecycle callback, useful for setting up the container. This
    * method may be a no-op if no setup is required.
    * 
    * @throws IOException
    *            if any communication problems with the server occur during
    *            setup. These will cause the test suite to fail.
    */
   public void setup() throws IOException;
   
   /**
    * Called after the TCK finishes executing the testsuite.
    * 
    * A TCK suite lifecycle callback, useful for cleaning up and shutting down
    * the container. This method may be a no-op if no setup is required.
    * 
    * @throws IOException
    *            if any communication problems with the server occur during
    *            cleanup. These will cause the test suite to fail.
    */
   public void cleanup() throws IOException;
   
}