/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.jsfsession.hellojsf;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.cactus.ServletTestCase;
import org.jboss.jsfunit.framework.FormAuthenticationStrategy;
import org.jboss.jsfunit.framework.InitialRequestStrategy;
import org.jboss.jsfunit.framework.WebClientSpec;
import org.jboss.jsfunit.jsfsession.JSFClientSession;
import org.jboss.jsfunit.jsfsession.JSFServerSession;
import org.jboss.jsfunit.jsfsession.JSFSession;

/*
 * Exception performing whole class analysis ignored.
 */
public class FormAuthenticationTest
extends ServletTestCase {
    public static Test suite() {
        return new TestSuite(FormAuthenticationTest.class);
    }

    public void testFormAuth() throws IOException {
        WebClientSpec wcSpec = new WebClientSpec("/jsf/form-secured-page.jsp");
        FormAuthenticationStrategy formStrategy = new FormAuthenticationStrategy("user", "password", "login_button");
        wcSpec.setInitialRequestStrategy((InitialRequestStrategy)formStrategy);
        JSFSession jsfSession = new JSFSession(wcSpec);
        JSFServerSession server = jsfSession.getJSFServerSession();
        FormAuthenticationTest.assertEquals((String)"/form-secured-page.jsp", (String)server.getCurrentViewID());
        JSFClientSession client = jsfSession.getJSFClientSession();
        FormAuthenticationTest.assertTrue((boolean)client.getPageAsText().contains("Welcome to the Form Secured Application Page"));
    }

    public void testFormAuthNonStandard() throws IOException {
        WebClientSpec wcSpec = new WebClientSpec("/jsf/form-secured-page.jsp");
        FormAuthenticationStrategy formStrategy = new FormAuthenticationStrategy("user", "password", "login_button", "j_username", "j_password");
        wcSpec.setInitialRequestStrategy((InitialRequestStrategy)formStrategy);
        JSFSession jsfSession = new JSFSession(wcSpec);
        JSFServerSession server = jsfSession.getJSFServerSession();
        FormAuthenticationTest.assertEquals((String)"/form-secured-page.jsp", (String)server.getCurrentViewID());
        JSFClientSession client = jsfSession.getJSFClientSession();
        FormAuthenticationTest.assertTrue((boolean)client.getPageAsText().contains("Welcome to the Form Secured Application Page"));
    }

    public void testInvalidLogin() throws IOException {
        WebClientSpec wcSpec = new WebClientSpec("/jsf/form-secured-page.jsp");
        FormAuthenticationStrategy formStrategy = new FormAuthenticationStrategy("invaliduser", "invalidpassword", "login_button");
        wcSpec.setInitialRequestStrategy((InitialRequestStrategy)formStrategy);
        JSFSession jsfSession = new JSFSession(wcSpec);
        JSFClientSession client = jsfSession.getJSFClientSession();
        FormAuthenticationTest.assertTrue((boolean)client.getPageAsText().contains("Error logging in"));
    }
}

