/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Utils {
    public static void copy(File srcfile, File destfile) throws Exception {
        if (srcfile.isDirectory()) {
            destfile.mkdirs();
            String[] files = srcfile.list();
            for (int i = 0; i < files.length; ++i) {
                String newSrcFile = srcfile.getPath() + File.separator + files[i];
                String newDestFile = destfile.getPath() + File.separator + files[i];
                Utils.copy(new File(newSrcFile), new File(newDestFile));
            }
        } else if (srcfile.isFile()) {
            FileChannel inputChannel = new FileInputStream(srcfile).getChannel();
            FileChannel outputChannel = new FileOutputStream(destfile).getChannel();
            inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
            inputChannel.close();
            outputChannel.close();
        } else {
            throw new Exception("Invalid file : " + srcfile);
        }
    }

    public static void unzip(ZipFile zipFile, File destDirectory) throws Exception {
        if (!destDirectory.exists()) {
            destDirectory.mkdir();
        } else if (!destDirectory.isDirectory()) {
            throw new Exception("The destDirectory file already exists and is not a directory");
        }
        Enumeration<? extends ZipEntry> enumer = zipFile.entries();
        while (enumer.hasMoreElements()) {
            int c;
            ZipEntry zipEntry = enumer.nextElement();
            if (zipEntry.isDirectory()) {
                File dir = new File(destDirectory, zipEntry.toString());
                dir.mkdir();
                continue;
            }
            File file = new File(destDirectory, zipEntry.toString());
            InputStream is = zipFile.getInputStream(zipEntry);
            FileOutputStream os = new FileOutputStream(file);
            while ((c = is.read()) != -1) {
                ((OutputStream)os).write(c);
            }
            is.close();
            ((OutputStream)os).close();
        }
    }

    public static void zip(File srcDirectory, File destFile) throws Exception {
        Utils.zip(srcDirectory, destFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File srcDirectory, File destFile, Boolean isArchive) throws Exception {
        if (destFile.exists()) {
            throw new Exception("The destFile [ + " + destFile + " already exists, cannot zip to an already existing file");
        }
        FileOutputStream os = new FileOutputStream(destFile);
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            if (isArchive.booleanValue()) {
                Utils.archive("", srcDirectory, zos);
            } else {
                Utils.zip("", srcDirectory, zos);
            }
        }
        finally {
            zos.close();
            ((OutputStream)os).close();
        }
    }

    private static void zip(String prefix, File srcDirectory, ZipOutputStream zos) throws IOException {
        prefix = prefix + srcDirectory.getName() + "/";
        File[] children = srcDirectory.listFiles();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isDirectory()) {
                Utils.zip(prefix, children[i], zos);
                continue;
            }
            Utils.zipOneFile(prefix, children[i], zos);
        }
    }

    private static void zipOneFile(String prefix, File file, ZipOutputStream zos) throws IOException {
        int c;
        ZipEntry zipFileEntry = new ZipEntry(prefix + file.getName());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.getAbsolutePath()));
        zos.putNextEntry(zipFileEntry);
        while ((c = ((InputStream)in).read()) != -1) {
            zos.write(c);
        }
        ((InputStream)in).close();
        zos.flush();
    }

    private static void archive(String prefix, File archiveDirectory, ZipOutputStream zos) throws IOException {
        File[] children = archiveDirectory.listFiles();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isFile()) {
                Utils.zipOneFile("", children[i], zos);
                continue;
            }
            Utils.zip(prefix, children[i], zos);
        }
    }

    public static File explodeArchive(ZipFile archiveFile, File destDirectory) throws Exception {
        if (!destDirectory.exists()) {
            destDirectory.mkdir();
        } else if (!destDirectory.isDirectory()) {
            throw new Exception("The destDirectory file already exists and is not a directory ");
        }
        String archiveName = Utils.getArchiveName(archiveFile);
        File explodedArchive = new File(destDirectory + File.separator + archiveName);
        Utils.unzip(archiveFile, explodedArchive);
        return explodedArchive;
    }

    public static String getArchiveName(ZipFile file) {
        String filePath = file.getName();
        int lastSeparator = filePath.lastIndexOf(File.separator);
        String fileName = filePath.substring(lastSeparator);
        return fileName;
    }

    public static void archive(File explodedArchive, File destArchive) throws Exception {
        if (destArchive.exists()) {
            throw new Exception("The destArchive " + destArchive + "already exists");
        }
        Utils.zip(explodedArchive, destArchive, true);
    }
}

