/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.web.jsf.integration.config;


import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.myfaces.webapp.StartupServletContextListener;

/**
 * This ServletContextListener sets up a JBoss-specific environment for JSF
 * and then delegates the rest of the setup to MyFaces.
 *
 * @author Stan Silvert
 */
public abstract class JBossMyFacesServletContextListener extends StartupServletContextListener
{
    protected ServletContext servletContext;
    
    protected boolean initialized = false;

    protected JBossJSFInitializer initializer;
    
    @Override
    public void contextInitialized(ServletContextEvent event) 
    {
        this.servletContext = event.getServletContext();
        this.initializer = new JBossJSFInitializer(this.servletContext);
  
        initializer.initializeJspRuntime();

        initializer.addFacesMappings();

        doVersionSpecificInitialization();
        
        super.contextInitialized(event);
        //initialized = true;
    }

    public abstract void doVersionSpecificInitialization();

    @Override
    public void contextDestroyed(ServletContextEvent event) 
    {
       // calling super.contextDestroyed() here throws exception.
       // not sure why
      /*  if (initialized)
        {
           super.contextDestroyed(event);
           initialized = false;
        } */
    }

}
