/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdf.stacks.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.jdf.stacks.client.DefaultStacksClientConfiguration;
import org.jboss.jdf.stacks.client.StacksClientConfiguration;
import org.jboss.jdf.stacks.client.messages.JBossLoggingMessages;
import org.jboss.jdf.stacks.client.messages.StacksMessages;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.jdf.stacks.parser.Parser;

public class StacksClient {
    private StacksClientConfiguration actualConfiguration;
    private StacksMessages msg;

    public StacksClient() {
        this(new DefaultStacksClientConfiguration());
    }

    public StacksClient(StacksClientConfiguration configuration) {
        this(configuration, new JBossLoggingMessages());
    }

    public StacksClient(StacksClientConfiguration configuration, StacksMessages stacksMessagesImpl) {
        this.msg = stacksMessagesImpl;
        this.actualConfiguration = configuration;
    }

    private Stacks initializeStacks() {
        InputStream inputStream = null;
        try {
            inputStream = this.getStacksInputStream();
            Stacks stacks = null;
            if (inputStream != null) {
                stacks = new Parser().parse(inputStream);
            }
            Stacks stacks2 = stacks;
            return stacks2;
        }
        catch (FileNotFoundException e) {
            this.msg.showErrorMessageWithCause("FileNotFoundException", e);
            return null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.msg.showErrorMessageWithCause("Something bad happened when closing the inputstream", e);
                }
            }
        }
    }

    public Stacks getStacks() {
        return this.initializeStacks();
    }

    public StacksClientConfiguration getActualConfiguration() {
        return this.actualConfiguration;
    }

    private InputStream getStacksInputStream() throws FileNotFoundException {
        InputStream repoStream = this.getCachedRepoStream(false);
        URL url = this.actualConfiguration.getUrl();
        if (repoStream == null && this.actualConfiguration.isOnline()) {
            this.msg.showDebugMessage("Local cache file " + this.getLocalCacheFile() + " doesn't exist or cache has been expired");
            try {
                this.msg.showDebugMessage("Retrieving Stacks from Remote repository " + url);
                repoStream = this.retrieveStacksFromRemoteRepository(url);
                this.setCachedRepoStream(repoStream);
                this.msg.showDebugMessage("Forcing the use of local cache after download file without error from " + url);
                repoStream = this.getCachedRepoStream(true);
            }
            catch (Exception e) {
                this.msg.showWarnMessage("It was not possible to contact the repository at " + url + " . Cause " + e.getMessage());
                this.msg.showWarnMessage("Falling back to cache!");
                repoStream = this.getCachedRepoStream(true);
            }
        }
        if (repoStream == null) {
            this.msg.showWarnMessage("Cache empty. Falling back to embed file");
            return this.getClass().getResourceAsStream("/stacks.yaml");
        }
        return repoStream;
    }

    private InputStream retrieveStacksFromRemoteRepository(URL url) throws Exception {
        if (url.getProtocol().startsWith("http")) {
            HttpGet httpGet = new HttpGet(url.toURI());
            DefaultHttpClient client = new DefaultHttpClient();
            this.configureProxy(client);
            HttpResponse httpResponse = client.execute((HttpUriRequest)httpGet);
            switch (httpResponse.getStatusLine().getStatusCode()) {
                case 200: {
                    this.msg.showDebugMessage("Connected to repository! Getting available Stacks");
                    break;
                }
                case 404: {
                    this.msg.showErrorMessage("Failed! (Stacks file not found: " + url + ")");
                    return null;
                }
                default: {
                    this.msg.showErrorMessage("Failed! (server returned status code: " + httpResponse.getStatusLine().getStatusCode());
                    return null;
                }
            }
            return httpResponse.getEntity().getContent();
        }
        if (url.getProtocol().startsWith("file")) {
            return new FileInputStream(new File(url.toURI()));
        }
        return null;
    }

    private void configureProxy(DefaultHttpClient client) {
        if (this.actualConfiguration.getProxyHost() != null && !this.actualConfiguration.getProxyHost().isEmpty()) {
            String proxyHost = this.actualConfiguration.getProxyHost();
            int proxyPort = this.actualConfiguration.getProxyPort();
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUsername = this.actualConfiguration.getProxyUser();
            if (proxyUsername != null && !proxyUsername.isEmpty()) {
                String proxyPassword = this.actualConfiguration.getProxyPassword();
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                client.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
            }
        }
    }

    public File getLocalCacheFile() {
        String repo = this.actualConfiguration.getUrl().toString().replaceAll("[^a-zA-Z_0-9]", "");
        return new File(System.getProperty("java.io.tmpdir"), String.valueOf(repo) + "stacks.yaml");
    }

    private InputStream getCachedRepoStream(boolean force) throws FileNotFoundException {
        String logmessage = "Local file %1s %2s used! Reason: Force:[%3b] - Online:[%4b] - LastModification: %5d/%6d";
        File localCacheFile = this.getLocalCacheFile();
        if (localCacheFile.exists()) {
            int cacheSeconds = this.actualConfiguration.getCacheRefreshPeriodInSeconds();
            boolean online = this.actualConfiguration.isOnline();
            long cachedvalidity = 1000 * cacheSeconds;
            long lastModified = localCacheFile.lastModified();
            long timeSinceLastModification = System.currentTimeMillis() - lastModified;
            if (force || !online || timeSinceLastModification <= cachedvalidity) {
                this.msg.showDebugMessage(String.format("Local file %1s %2s used! Reason: Force:[%3b] - Online:[%4b] - LastModification: %5d/%6d", localCacheFile, "was", force, online, timeSinceLastModification, cachedvalidity));
                return new FileInputStream(localCacheFile);
            }
            this.msg.showDebugMessage(String.format("Local file %1s %2s used! Reason: Force:[%3b] - Online:[%4b] - LastModification: %5d/%6d", localCacheFile, "was not", force, online, timeSinceLastModification, cachedvalidity));
        }
        return null;
    }

    private void setCachedRepoStream(InputStream stream) throws IOException {
        File localCacheFile = this.getLocalCacheFile();
        this.msg.showDebugMessage("Content stored at " + localCacheFile);
        if (!localCacheFile.exists()) {
            localCacheFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(localCacheFile);
        int i = 0;
        while ((i = stream.read()) != -1) {
            fos.write(i);
        }
        fos.close();
    }

    public void eraseRepositoryCache() {
        File localFile = this.getLocalCacheFile();
        localFile.delete();
        this.msg.showDebugMessage("Cache erased");
    }
}

