/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployer;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.wsf.container.jboss50.deployer.DeployerHook;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.deployment.DeploymentAspectManagerFactory;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

public abstract class AbstractDeployerHook
implements DeployerHook {
    protected final Logger log = Logger.getLogger(this.getClass());
    private DeploymentAspectManager deploymentAspectManager;
    private DeploymentModelFactory deploymentModelFactory;
    protected String deploymentManagerName;

    public void setDeploymentManagerName(String deploymentManagerName) {
        this.deploymentManagerName = deploymentManagerName;
    }

    public DeploymentAspectManager getDeploymentAspectManager() {
        if (null == this.deploymentAspectManager) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            this.deploymentAspectManager = ((DeploymentAspectManagerFactory)spiProvider.getSPI(DeploymentAspectManagerFactory.class)).getDeploymentAspectManager(this.deploymentManagerName);
        }
        return this.deploymentAspectManager;
    }

    public DeploymentModelFactory getDeploymentModelFactory() {
        if (null == this.deploymentModelFactory) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            this.deploymentModelFactory = (DeploymentModelFactory)spiProvider.getSPI(DeploymentModelFactory.class);
        }
        return this.deploymentModelFactory;
    }

    public ArchiveDeployment newDeployment(DeploymentUnit unit) {
        try {
            DeploymentModelFactory factory = this.getDeploymentModelFactory();
            ArchiveDeployment dep = (ArchiveDeployment)factory.newDeployment(unit.getSimpleName(), unit.getClassLoader());
            if (unit.getParent() != null) {
                DeploymentUnit parentUnit = unit.getParent();
                ArchiveDeployment parentDep = (ArchiveDeployment)factory.newDeployment(parentUnit.getSimpleName(), parentUnit.getClassLoader());
                dep.setParent(parentDep);
            }
            return dep;
        }
        catch (Exception ex) {
            throw new WSFDeploymentException("Cannot load spi.deployment.Deployment class", (Throwable)ex);
        }
    }

    public Endpoint newEndpoint(String targetBean) {
        try {
            return this.getDeploymentModelFactory().newEndpoint(targetBean);
        }
        catch (Exception ex) {
            throw new WSFDeploymentException("Cannot load spi.deployment.Endpoint class", (Throwable)ex);
        }
    }

    public boolean ignoreDeployment(DeploymentUnit unit) {
        String name = unit.getName();
        return name.startsWith("jboss:id=") && name.indexOf("service=jacc") > 0;
    }

    public abstract Deployment.DeploymentType getDeploymentType();
}

