/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.callback.CallbackStoreMBean;
import org.jboss.remoting.serialization.SerializationStreamFactory;
import org.jboss.remoting.util.SecurityUtility;

public class CallbackStore
implements CallbackStoreMBean {
    private static long previousTimestamp;
    private static int timestampCounter;
    private String filePath = null;
    private String fileSuffix = "ser";
    private boolean isStarted = false;
    private boolean purgeOnShutdown = false;
    private String serializationType = "java";
    public static final String FILE_PATH_KEY = "StoreFilePath";
    public static final String FILE_SUFFIX_KEY = "StoreFileSuffix";
    private static final Logger log;

    public CallbackStore() {
    }

    public CallbackStore(boolean purgeOnDestroy) {
        this.purgeOnShutdown = purgeOnDestroy;
    }

    public void start() throws Exception {
        if (!this.isStarted) {
            boolean madeDir;
            File storeFile;
            if (this.filePath == null) {
                try {
                    this.filePath = SecurityUtility.getSystemProperty("jboss.server.data.dir", "data");
                }
                catch (Exception e) {
                    log.debug((Object)"error", (Throwable)e);
                    this.filePath = "data";
                }
            }
            if (!(storeFile = new File(this.filePath)).exists() && !(madeDir = SecurityUtility.mkdirs(storeFile))) {
                throw new IOException("Can not create directory for store.  Path given: " + this.filePath);
            }
            this.isStarted = true;
        }
    }

    public void setPurgeOnShutdown(boolean purgeOnShutdown) {
        this.purgeOnShutdown = purgeOnShutdown;
    }

    public boolean getPurgeOnShutdown() {
        return this.purgeOnShutdown;
    }

    public void create() throws Exception {
    }

    public void stop() {
        this.isStarted = false;
    }

    public void destroy() {
        if (this.purgeOnShutdown) {
            this.purgeFiles();
        }
    }

    public void purgeFiles() {
        String[] fileList = this.getObjectFileList();
        String fileToDelete = null;
        for (int x = 0; x < fileList.length; ++x) {
            try {
                String separator = SecurityUtility.getSystemProperty("file.separator");
                fileToDelete = this.filePath + separator + fileList[x];
                final File currentFile = new File(fileToDelete);
                boolean deleted = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(currentFile.delete());
                    }
                });
                if (deleted) continue;
                log.warn((Object)("Error purging file " + fileToDelete));
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("Error purging file " + fileToDelete));
            }
        }
    }

    public void setConfig(Map config) {
        if (config != null) {
            String newSerializationType;
            String newFileSuffix;
            String newFilePath = (String)config.get(FILE_PATH_KEY);
            if (newFilePath != null) {
                this.filePath = newFilePath;
            }
            if ((newFileSuffix = (String)config.get(FILE_SUFFIX_KEY)) != null) {
                this.fileSuffix = newFileSuffix;
            }
            if ((newSerializationType = (String)config.get("serializationtype")) != null) {
                this.serializationType = newSerializationType;
            }
        }
    }

    public String getStoreFilePath() {
        return this.filePath;
    }

    public void setStoreFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getStoreFileSuffix() {
        return this.fileSuffix;
    }

    public void setStoreFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public int size() {
        this.verifyStarted();
        String[] objectFileList = this.getObjectFileList();
        if (objectFileList != null) {
            return objectFileList.length;
        }
        return 0;
    }

    private void verifyStarted() {
        if (!this.isStarted) {
            throw new RuntimeException("Can not call upon this store method before it has been started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNext() throws IOException {
        Object obj;
        block21: {
            this.verifyStarted();
            obj = null;
            String objectFilePath = null;
            String string = this.filePath;
            synchronized (string) {
                IOException ioe22;
                ObjectInputStream in;
                block19: {
                    String[] objectFileList = this.getObjectFileList();
                    FileInputStream inFile = null;
                    in = null;
                    if (objectFileList == null || objectFileList.length <= 0) break block21;
                    try {
                        String separator = SecurityUtility.getSystemProperty("file.separator");
                        objectFilePath = this.filePath + separator + objectFileList[0];
                        inFile = SecurityUtility.getFileInputStream(objectFilePath);
                        in = SerializationStreamFactory.getManagerInstance(this.serializationType).createRegularInput(inFile);
                        try {
                            obj = in.readObject();
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException("Error loading persisted object.  Could not load class (" + e.getMessage() + ").");
                        }
                        Object var10_9 = null;
                        if (inFile == null) break block19;
                    }
                    catch (Throwable throwable) {
                        IOException ioe22;
                        Object var10_10 = null;
                        if (inFile != null) {
                            try {
                                inFile.close();
                            }
                            catch (IOException ioe22) {
                                log.debug((Object)"Error closing FileInputStream.", (Throwable)ioe22);
                            }
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ioe22) {
                                log.debug((Object)"Error closing ObjectInputStream.", (Throwable)ioe22);
                            }
                        }
                        if (objectFilePath != null) {
                            File objectFile = new File(objectFilePath);
                            boolean isDeleted = (Boolean)AccessController.doPrivileged(new PrivilegedAction(objectFile){
                                private final /* synthetic */ File val$objectFile;
                                {
                                    this.val$objectFile = file;
                                }

                                public Object run() {
                                    return new Boolean(this.val$objectFile.delete());
                                }
                            });
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("object file (" + objectFilePath + ") has been deleted - " + isDeleted));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inFile.close();
                    }
                    catch (IOException ioe22) {
                        log.debug((Object)"Error closing FileInputStream.", (Throwable)ioe22);
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe22) {
                        log.debug((Object)"Error closing ObjectInputStream.", (Throwable)ioe22);
                    }
                }
                if (objectFilePath == null) break block21;
                File objectFile = new File(objectFilePath);
                boolean isDeleted = (Boolean)AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("object file (" + objectFilePath + ") has been deleted - " + isDeleted));
                }
            }
        }
        return obj;
    }

    private String[] getObjectFileList() {
        final File storePath = new File(this.filePath);
        Object[] objectFileList = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return storePath.list(new StoreFileFilter());
            }
        });
        Arrays.sort(objectFileList);
        return objectFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final Serializable object) throws IOException {
        this.verifyStarted();
        String string = this.filePath;
        synchronized (string) {
            block21: {
                long currentTimestamp = System.currentTimeMillis();
                if (previousTimestamp == currentTimestamp) {
                    ++timestampCounter;
                } else {
                    previousTimestamp = currentTimestamp;
                    timestampCounter = 0;
                }
                StringBuffer path = new StringBuffer(this.filePath);
                String separator = SecurityUtility.getSystemProperty("file.separator");
                path.append(separator).append(String.valueOf(currentTimestamp));
                path.append("-").append(timestampCounter).append(".").append(this.fileSuffix);
                File storeFile = new File(path.toString());
                FileOutputStream outFile = null;
                ObjectOutputStream out = null;
                try {
                    outFile = SecurityUtility.getFileOutputStream(storeFile, false);
                    if (this.serializationType.indexOf("jboss") > 0) {
                        out = SerializationStreamFactory.getManagerInstance(this.serializationType).createOutput(outFile);
                        out.writeObject(object);
                        out.flush();
                        break block21;
                    }
                    try {
                        final FileOutputStream finalOutFile = outFile;
                        out = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                ObjectOutputStream out = SerializationStreamFactory.getManagerInstance(CallbackStore.this.serializationType).createOutput(finalOutFile);
                                out.writeObject(object);
                                out.flush();
                                return out;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (IOException)e.getCause();
                    }
                }
                finally {
                    if (outFile != null) {
                        try {
                            outFile.close();
                        }
                        catch (IOException ioe) {
                            log.debug((Object)"Error closing FileInputStream.", (Throwable)ioe);
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe) {
                            log.debug((Object)"Error closing ObjectInputStream.", (Throwable)ioe);
                        }
                    }
                }
            }
        }
    }

    static {
        log = Logger.getLogger((Class)CallbackStore.class);
    }

    public class StoreFileFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(CallbackStore.this.fileSuffix);
        }
    }
}

