/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wscoor.client;

import com.arjuna.webservices11.wsaddr.AddressingHelper;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.wsf.common.addressing.MAP;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.ActivationPortType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.ActivationService;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegistrationPortType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegistrationService;

public class WSCOORClient {
    private static ThreadLocal<ActivationService> activationService = new ThreadLocal();
    private static ThreadLocal<RegistrationService> registrationService = new ThreadLocal();

    private static synchronized ActivationService getActivationService() {
        if (activationService.get() == null) {
            activationService.set(new ActivationService());
        }
        return activationService.get();
    }

    private static synchronized RegistrationService getRegistrationService() {
        if (registrationService.get() == null) {
            registrationService.set(new RegistrationService());
        }
        return registrationService.get();
    }

    public static ActivationPortType getActivationPort(MAP map, String action) {
        ActivationService service = WSCOORClient.getActivationService();
        ActivationPortType port = (ActivationPortType)service.getPort(ActivationPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        String to = map.getTo();
        Map requestContext = bindingProvider.getRequestContext();
        AddressingHelper.configureRequestContext(requestContext, map, to, action);
        return port;
    }

    public static RegistrationPortType getRegistrationPort(W3CEndpointReference endpointReference, String action, String messageID) {
        RegistrationService service = WSCOORClient.getRegistrationService();
        RegistrationPortType port = (RegistrationPortType)service.getPort((EndpointReference)endpointReference, RegistrationPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        Map requestContext = bindingProvider.getRequestContext();
        MAP map = AddressingHelper.outboundMap(requestContext);
        AddressingHelper.installActionMessageID(map, action, messageID);
        AddressingHelper.configureRequestContext(requestContext, map.getTo(), action);
        return port;
    }
}

