/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.util;

import com.arjuna.webservices.logging.WSCLogger;
import com.arjuna.webservices.util.QNameHelper;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StreamHelper {
    private static final String UNBOUND_NAMESPACE = "http://www.arjuna.com/stax/parsing/unboundnamespace";

    public static String writeStartElement(XMLStreamWriter out, QName elementName) throws XMLStreamException {
        boolean writeNamespace;
        String namespaceURI = QNameHelper.getNormalisedValue((String)elementName.getNamespaceURI());
        String localName = elementName.getLocalPart();
        NamespaceContext namespaceContext = out.getNamespaceContext();
        boolean bl = writeNamespace = namespaceContext.getPrefix(namespaceURI) == null;
        if (writeNamespace) {
            String prefix = QNameHelper.getNormalisedValue((String)elementName.getPrefix());
            String origNamespace = QNameHelper.getNormalisedValue((String)namespaceContext.getNamespaceURI(prefix));
            if (prefix.length() == 0) {
                out.setDefaultNamespace(namespaceURI);
                out.writeStartElement(namespaceURI, localName);
                out.writeDefaultNamespace(namespaceURI);
            } else {
                out.setPrefix(prefix, namespaceURI);
                out.writeStartElement(namespaceURI, localName);
                out.writeNamespace(prefix, namespaceURI);
            }
            return origNamespace;
        }
        out.writeStartElement(namespaceURI, localName);
        return null;
    }

    public static void writeEndElement(XMLStreamWriter out, String prefix, String namespaceURI) throws XMLStreamException {
        out.writeEndElement();
        if (namespaceURI != null) {
            String resetNamespace;
            String string = resetNamespace = namespaceURI.length() == 0 ? UNBOUND_NAMESPACE : namespaceURI;
            if (prefix.length() == 0) {
                out.setDefaultNamespace(resetNamespace);
            } else {
                out.setPrefix(prefix, resetNamespace);
            }
        }
    }

    public static void writeAttributes(XMLStreamWriter out, Map attributes) throws XMLStreamException {
        Set entrySet = attributes.entrySet();
        for (Map.Entry entry : entrySet) {
            QName name = (QName)entry.getKey();
            Object value = entry.getValue();
            StreamHelper.writeAttribute(out, name, value);
        }
    }

    public static void writeAttribute(XMLStreamWriter out, QName attributeName, Object attributeValue) throws XMLStreamException {
        if (attributeValue instanceof QName) {
            StreamHelper.writeAttribute(out, attributeName, (QName)attributeValue);
        } else {
            StreamHelper.writeAttribute(out, attributeName, attributeValue.toString());
        }
    }

    public static void writeAttribute(XMLStreamWriter out, QName attributeName, QName attributeValue) throws XMLStreamException {
        String namespaceURI = QNameHelper.getNormalisedValue((String)attributeValue.getNamespaceURI());
        if (namespaceURI.length() == 0) {
            StreamHelper.writeAttribute(out, attributeName, attributeValue.getLocalPart());
        } else {
            NamespaceContext namespaceContext = out.getNamespaceContext();
            String origPrefix = namespaceContext.getPrefix(namespaceURI);
            if (origPrefix == null) {
                String prefix = QNameHelper.getNormalisedValue((String)attributeValue.getPrefix());
                StreamHelper.writeNamespace(out, prefix, namespaceURI);
                StreamHelper.writeAttribute(out, attributeName, QNameHelper.toQualifiedName((QName)attributeValue));
            } else {
                StreamHelper.writeAttribute(out, attributeName, QNameHelper.toQualifiedName((String)origPrefix, (String)attributeValue.getLocalPart()));
            }
        }
    }

    public static void writeAttribute(XMLStreamWriter out, QName attributeName, String attributeValue) throws XMLStreamException {
        String namespaceURI = QNameHelper.getNormalisedValue((String)attributeName.getNamespaceURI());
        String localName = attributeName.getLocalPart();
        if (namespaceURI.length() == 0) {
            out.writeAttribute(localName, attributeValue);
        } else {
            String prefix = QNameHelper.getNormalisedValue((String)attributeName.getPrefix());
            StreamHelper.writeNamespace(out, prefix, namespaceURI);
            out.writeAttribute(namespaceURI, localName, attributeValue);
        }
    }

    public static void writeQualifiedName(XMLStreamWriter out, QName qName) throws XMLStreamException {
        String namespaceURI = QNameHelper.getNormalisedValue((String)qName.getNamespaceURI());
        if (namespaceURI.length() == 0) {
            out.writeCharacters(QNameHelper.toQualifiedName((QName)qName));
        } else {
            NamespaceContext namespaceContext = out.getNamespaceContext();
            String origPrefix = namespaceContext.getPrefix(namespaceURI);
            if (origPrefix == null) {
                String prefix = QNameHelper.getNormalisedValue((String)qName.getPrefix());
                StreamHelper.writeNamespace(out, prefix, namespaceURI);
                out.writeCharacters(QNameHelper.toQualifiedName((QName)qName));
            } else {
                out.writeCharacters(QNameHelper.toQualifiedName((String)origPrefix, (String)qName.getLocalPart()));
            }
        }
    }

    public static void writeNamespace(XMLStreamWriter out, String prefix, String namespaceURI) throws XMLStreamException {
        boolean writeNamespace;
        NamespaceContext namespaceContext = out.getNamespaceContext();
        boolean bl = writeNamespace = namespaceContext.getPrefix(namespaceURI) == null;
        if (writeNamespace) {
            out.setPrefix(prefix, namespaceURI);
            out.writeNamespace(prefix, namespaceURI);
        }
    }

    public static void skipToNextStartElement(XMLStreamReader streamReader) throws XMLStreamException {
        if (streamReader.hasNext()) {
            streamReader.nextTag();
            if (streamReader.isEndElement()) {
                throw new XMLStreamException(WSCLogger.i18NLogger.get_webservices_util_StreamHelper_1(streamReader.getName()));
            }
        } else {
            throw new XMLStreamException(WSCLogger.i18NLogger.get_webservices_util_StreamHelper_2());
        }
    }

    public static void skipToStartElement(XMLStreamReader streamReader) throws XMLStreamException {
        while (!streamReader.isStartElement()) {
            if (streamReader.hasNext()) {
                streamReader.next();
                continue;
            }
            throw new XMLStreamException(WSCLogger.i18NLogger.get_webservices_util_StreamHelper_2());
        }
    }

    public static void checkNextStartTag(XMLStreamReader streamReader, QName expected) throws XMLStreamException {
        StreamHelper.skipToNextStartElement(streamReader);
        StreamHelper.checkTag(streamReader, expected);
    }

    public static void checkTag(XMLStreamReader streamReader, QName expected) throws XMLStreamException {
        QName elementName = streamReader.getName();
        if (!expected.equals(elementName)) {
            throw new XMLStreamException(WSCLogger.i18NLogger.get_webservices_util_StreamHelper_3(elementName));
        }
    }

    public static boolean checkParentFinished(XMLStreamReader streamReader) throws XMLStreamException {
        return streamReader.nextTag() == 2;
    }
}

