/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.stub;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.subordinate.SubordinateATCoordinator;
import com.arjuna.wst.Aborted;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.PersistableParticipant;
import com.arjuna.wst.Prepared;
import com.arjuna.wst.ReadOnly;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.Vote;
import com.arjuna.wst.WrongStateException;
import java.io.IOException;
import org.jboss.jbossts.xts.recovery.participant.at.PersistableATParticipant;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryManager;

public class SubordinateDurable2PCStub
implements Durable2PCParticipant,
PersistableParticipant,
PersistableATParticipant {
    private SubordinateATCoordinator coordinator;
    private String coordinatorId;
    private boolean recovered;

    public SubordinateDurable2PCStub(SubordinateATCoordinator coordinator) {
        this.coordinator = coordinator;
        this.coordinatorId = coordinator.get_uid().stringForm();
        this.recovered = false;
    }

    public SubordinateDurable2PCStub() {
        this.coordinator = null;
        this.coordinatorId = null;
        this.recovered = true;
    }

    public Vote prepare() throws WrongStateException, SystemException {
        switch (this.coordinator.prepare()) {
            case 0: {
                return new Prepared();
            }
            case 2: {
                return new ReadOnly();
            }
        }
        return new Aborted();
    }

    public void commit() throws WrongStateException, SystemException {
        if (!this.isRecovered()) {
            this.coordinator.commit();
        } else {
            XTSATRecoveryManager recoveryManager = null;
            boolean isRecoveryScanStarted = false;
            if (this.coordinator == null) {
                recoveryManager = XTSATRecoveryManager.getRecoveryManager();
                isRecoveryScanStarted = recoveryManager.isSubordinateCoordinatorRecoveryStarted();
                this.coordinator = SubordinateATCoordinator.getRecoveredCoordinator((String)this.coordinatorId);
            }
            if (this.coordinator == null) {
                if (!isRecoveryScanStarted) {
                    throw new SystemException();
                }
            } else {
                if (!this.coordinator.isActivated()) {
                    throw new SystemException();
                }
                int status = this.coordinator.status();
                if (status == 5 || status == 6) {
                    this.coordinator.commit();
                    SubordinateATCoordinator.removeActiveProxy((String)this.coordinatorId);
                    status = this.coordinator.status();
                }
                if (status == 6) {
                    throw new SystemException();
                }
            }
        }
    }

    public void rollback() throws WrongStateException, SystemException {
        if (!this.isRecovered()) {
            this.coordinator.rollback();
        } else {
            XTSATRecoveryManager recoveryManager = XTSATRecoveryManager.getRecoveryManager();
            boolean isRecoveryScanStarted = recoveryManager.isSubordinateCoordinatorRecoveryStarted();
            this.coordinator = SubordinateATCoordinator.getRecoveredCoordinator((String)this.coordinatorId);
            if (this.coordinator == null) {
                if (!isRecoveryScanStarted) {
                    throw new SystemException();
                }
            } else {
                if (!this.coordinator.isActivated()) {
                    throw new SystemException();
                }
                int status = this.coordinator.status();
                if (status == 4 || status == 11 || status == 2 || status == 3) {
                    this.coordinator.rollback();
                    SubordinateATCoordinator.removeActiveProxy((String)this.coordinatorId);
                    int n = this.coordinator.status();
                }
            }
        }
    }

    public void unknown() throws SystemException {
        this.coordinator.unknown();
    }

    public void error() throws SystemException {
        this.coordinator.error();
    }

    public boolean saveState(OutputObjectState oos) {
        try {
            oos.packString(this.coordinatorId);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean restoreState(InputObjectState ios) {
        try {
            this.coordinatorId = ios.unpackString();
            SubordinateATCoordinator.addActiveProxy((String)this.coordinatorId);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public byte[] getRecoveryState() throws Exception {
        OutputObjectState oos = new OutputObjectState();
        oos.packString(this.getClass().getName());
        this.saveState(oos);
        return oos.buffer();
    }
}

