/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging.engines;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.util.TransportTimer;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsba.ParticipantCompletionCoordinatorInboundEvents;
import com.arjuna.webservices11.wsba.State;
import com.arjuna.webservices11.wsba.client.ParticipantCompletionParticipantClient;
import com.arjuna.webservices11.wsba.processors.ParticipantCompletionCoordinatorProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst11.BAParticipantManager;
import javax.xml.namespace.QName;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.wsf.common.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsba._2006._06.ExceptionType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.NotificationType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.StatusType;

public class ParticipantCompletionCoordinatorEngine
implements ParticipantCompletionCoordinatorInboundEvents {
    private final String id;
    private final InstanceIdentifier instanceIdentifier;
    private final W3CEndpointReference participant;
    private BAParticipantManager coordinator;
    private State state;
    private State failureState;
    private boolean recovered;

    public ParticipantCompletionCoordinatorEngine(String id, W3CEndpointReference participant) {
        this(id, participant, State.STATE_ACTIVE, false);
    }

    public ParticipantCompletionCoordinatorEngine(String id, W3CEndpointReference participant, State state, boolean recovered) {
        this.id = id;
        this.instanceIdentifier = new InstanceIdentifier(id);
        this.participant = participant;
        this.state = state;
        this.failureState = null;
        this.recovered = recovered;
        if (!recovered || state == State.STATE_COMPLETED || state == State.STATE_CLOSING) {
            ParticipantCompletionCoordinatorProcessor.getProcessor().activateCoordinator(this, id);
        }
    }

    public void setCoordinator(BAParticipantManager coordinator) {
        this.coordinator = coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelled(NotificationType cancelled, MAP map, ArjunaContext arjunaContext) {
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            State current = this.state;
            if (current == State.STATE_CANCELING) {
                this.ended();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed(NotificationType closed, MAP map, ArjunaContext arjunaContext) {
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            State current = this.state;
            if (current == State.STATE_CLOSING) {
                this.ended();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compensated(NotificationType compensated, MAP map, ArjunaContext arjunaContext) {
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            State current = this.state;
            if (current == State.STATE_COMPENSATING) {
                this.ended();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(NotificationType completed, MAP map, ArjunaContext arjunaContext) {
        State current;
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE || current == State.STATE_CANCELING) {
                this.changeState(State.STATE_COMPLETED);
            }
        }
        if (current == State.STATE_ACTIVE) {
            this.executeCompleted();
        } else if (current == State.STATE_CLOSING) {
            this.sendClose();
        } else if (current == State.STATE_CANCELING || current == State.STATE_COMPENSATING) {
            this.sendCompensate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit(NotificationType exit, MAP map, ArjunaContext arjunaContext) {
        State current;
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE || current == State.STATE_CANCELING) {
                this.changeState(State.STATE_EXITING);
            }
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_CANCELING) {
            this.executeExit();
        } else if (current == State.STATE_ENDED) {
            this.sendExited();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail(ExceptionType fail, MAP map, ArjunaContext arjunaContext) {
        State current;
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_FAILING_ACTIVE);
            } else if (current == State.STATE_CANCELING) {
                this.failureState = State.STATE_FAILING_CANCELING;
                this.ended();
            } else if (current == State.STATE_COMPENSATING) {
                this.failureState = State.STATE_FAILING_COMPENSATING;
                this.ended();
            }
        }
        if (current == State.STATE_ACTIVE) {
            this.executeFail(fail.getExceptionIdentifier());
        } else if (current == State.STATE_CANCELING || current == State.STATE_COMPENSATING || current == State.STATE_ENDED) {
            this.sendFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cannotComplete(NotificationType cannotComplete, MAP map, ArjunaContext arjunaContext) {
        State current;
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE || this.state == State.STATE_CANCELING) {
                this.changeState(State.STATE_NOT_COMPLETING);
            }
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_CANCELING) {
            this.executeCannotComplete();
        } else if (current == State.STATE_ENDED) {
            this.sendNotCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStatus(NotificationType getStatus, MAP map, ArjunaContext arjunaContext) {
        State current;
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            current = this.state;
        }
        this.sendStatus(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void status(StatusType status, MAP map, ArjunaContext arjunaContext) {
        State current;
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            current = this.state;
        }
        this.sendStatus(current);
    }

    public synchronized State getStatus() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State cancel() {
        State current;
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_CANCELING);
            }
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_CANCELING) {
            this.sendCancel();
            current = this.waitForState(State.STATE_CANCELING, TransportTimer.getTransportTimeout());
        }
        if (current == State.STATE_ENDED && this.failureState != null) {
            return this.failureState;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State compensate() {
        State current;
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_COMPLETED) {
                this.changeState(State.STATE_COMPENSATING);
            }
        }
        if (current == State.STATE_COMPLETED || current == State.STATE_COMPENSATING) {
            this.sendCompensate();
            this.waitForState(State.STATE_COMPENSATING, TransportTimer.getTransportTimeout());
        }
        participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            if (this.state != State.STATE_COMPENSATING) {
                if (this.recovered) {
                    ParticipantCompletionCoordinatorProcessor.getProcessor().deactivateCoordinator(this);
                }
                if (this.state == State.STATE_ENDED && this.failureState != null) {
                    return this.failureState;
                }
                return this.state;
            }
            return State.STATE_COMPENSATING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State close() {
        State current;
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_COMPLETED) {
                this.changeState(State.STATE_CLOSING);
            }
        }
        if (current == State.STATE_COMPLETED || current == State.STATE_CLOSING) {
            this.sendClose();
            this.waitForState(State.STATE_CLOSING, TransportTimer.getTransportTimeout());
        }
        participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            if (this.state != State.STATE_CLOSING) {
                if (this.recovered) {
                    ParticipantCompletionCoordinatorProcessor.getProcessor().deactivateCoordinator(this);
                }
                if (this.state == State.STATE_ENDED && this.failureState != null) {
                    return this.failureState;
                }
                return this.state;
            }
            return State.STATE_CLOSING;
        }
    }

    @Override
    public void soapFault(SoapFault soapFault, MAP map, ArjunaContext arjunaContext) {
        this.ended();
    }

    private void sendClose() {
        block2: {
            MAP map = this.createContext();
            try {
                ParticipantCompletionParticipantClient.getClient().sendClose(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Close", (Object)th);
            }
        }
    }

    private void sendCompensate() {
        block2: {
            MAP map = this.createContext();
            try {
                ParticipantCompletionParticipantClient.getClient().sendCompensate(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Compensate", (Object)th);
            }
        }
    }

    private void sendCancel() {
        block2: {
            MAP map = this.createContext();
            try {
                ParticipantCompletionParticipantClient.getClient().sendCancel(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Cancel", (Object)th);
            }
        }
    }

    private void sendExited() {
        block2: {
            MAP map = this.createContext();
            try {
                ParticipantCompletionParticipantClient.getClient().sendExited(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Exited", (Object)th);
            }
        }
    }

    private void sendFailed() {
        block2: {
            MAP map = this.createContext();
            try {
                ParticipantCompletionParticipantClient.getClient().sendFailed(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Faulted", (Object)th);
            }
        }
    }

    private void sendNotCompleted() {
        block2: {
            MAP map = this.createContext();
            try {
                ParticipantCompletionParticipantClient.getClient().sendNotCompleted(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending NotCompleted", (Object)th);
            }
        }
    }

    private void sendStatus(State state) {
        block2: {
            MAP map = this.createContext();
            try {
                ParticipantCompletionParticipantClient.getClient().sendStatus(this.participant, map, this.instanceIdentifier, state.getValue());
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Status", (Object)th);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public W3CEndpointReference getParticipant() {
        return this.participant;
    }

    public BAParticipantManager getCoordinator() {
        return this.coordinator;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    private synchronized void changeState(State state) {
        if (this.state != state) {
            this.state = state;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private State waitForState(State origState, long delay) {
        long end = System.currentTimeMillis() + delay;
        ParticipantCompletionCoordinatorEngine participantCompletionCoordinatorEngine = this;
        synchronized (participantCompletionCoordinatorEngine) {
            long remaining;
            while (this.state == origState && (remaining = end - System.currentTimeMillis()) > 0L) {
                try {
                    this.wait(remaining);
                }
                catch (InterruptedException ie) {}
            }
            return this.state;
        }
    }

    private void executeCompleted() {
        block2: {
            try {
                this.coordinator.completed();
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception from coordinator completed", (Object)th);
            }
        }
    }

    private void executeExit() {
        try {
            this.coordinator.exit();
        }
        catch (Throwable th) {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Unexpected exception from coordinator exit", (Object)th);
            }
            return;
        }
        this.sendExited();
        this.ended();
    }

    private void executeFail(QName fail) {
        try {
            this.coordinator.fail(fail);
        }
        catch (Throwable th) {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Unexpected exception from coordinator fault", (Object)th);
            }
            return;
        }
        this.sendFailed();
        this.ended();
    }

    private void executeCannotComplete() {
        try {
            this.coordinator.cannotComplete();
        }
        catch (Throwable th) {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Unexpected exception from coordinator error", (Object)th);
            }
            return;
        }
        this.sendNotCompleted();
        this.ended();
    }

    private void ended() {
        this.changeState(State.STATE_ENDED);
        if (!this.recovered) {
            ParticipantCompletionCoordinatorProcessor.getProcessor().deactivateCoordinator(this);
        }
    }

    private MAP createContext() {
        String messageId = MessageId.getMessageId();
        return AddressingHelper.createNotificationContext((String)messageId);
    }
}

