/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.base.processors.ActivatedObjectProcessor;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.AtomicTransactionConstants;
import com.arjuna.webservices11.wsat.CoordinatorInboundEvents;
import com.arjuna.webservices11.wsat.client.ParticipantClient;
import com.arjuna.webservices11.wsat.processors.CoordinatorProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryManager;
import org.jboss.wsf.common.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;

public class CoordinatorProcessorImpl
extends CoordinatorProcessor {
    private final ActivatedObjectProcessor activatedObjectProcessor = new ActivatedObjectProcessor();

    @Override
    public void activateCoordinator(CoordinatorInboundEvents coordinator, String identifier) {
        this.activatedObjectProcessor.activateObject((Object)coordinator, identifier);
    }

    @Override
    public void deactivateCoordinator(CoordinatorInboundEvents coordinator) {
        this.activatedObjectProcessor.deactivateObject((Object)coordinator);
    }

    @Override
    public CoordinatorInboundEvents getCoordinator(String identifier) {
        return (CoordinatorInboundEvents)this.activatedObjectProcessor.getObject(identifier);
    }

    private CoordinatorInboundEvents getCoordinator(InstanceIdentifier instanceIdentifier) {
        String identifier = instanceIdentifier != null ? instanceIdentifier.getInstanceIdentifier() : null;
        return this.getCoordinator(identifier);
    }

    @Override
    public void aborted(Notification aborted, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.aborted(aborted, map, arjunaContext);
            }
            catch (Throwable th) {
                WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_aborted_1(th);
            }
        } else {
            WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_aborted_2(instanceIdentifier.toString());
        }
    }

    @Override
    public void committed(Notification committed, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.committed(committed, map, arjunaContext);
            }
            catch (Throwable th) {
                WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_committed_1(th);
            }
        } else {
            WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_committed_2(instanceIdentifier.toString());
        }
    }

    @Override
    public void prepared(Notification prepared, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.prepared(prepared, map, arjunaContext);
            }
            catch (Throwable th) {
                WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_prepared_1(th);
            }
        } else if (CoordinatorProcessorImpl.areRecoveryLogEntriesAccountedFor()) {
            WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_prepared_2(instanceIdentifier.toString());
            String identifierValue = instanceIdentifier.getInstanceIdentifier();
            if (identifierValue != null && identifierValue.length() > 0 && identifierValue.charAt(0) == 'D') {
                this.sendRollback(map, arjunaContext);
            } else {
                this.sendUnknownTransaction(map, arjunaContext);
            }
        } else {
            WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_prepared_3(instanceIdentifier.toString());
        }
    }

    @Override
    public void readOnly(Notification readOnly, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.readOnly(readOnly, map, arjunaContext);
            }
            catch (Throwable th) {
                WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_readOnly_1(th);
            }
        } else {
            WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_readOnly_2(instanceIdentifier.toString());
        }
    }

    @Override
    public void soapFault(SoapFault fault, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.soapFault(fault, map, arjunaContext);
            }
            catch (Throwable th) {
                WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_soapFault_1(th);
            }
        } else {
            WSTLogger.i18NLogger.warn_wst11_messaging_CoordinatorProcessorImpl_soapFault_2(instanceIdentifier.toString());
        }
    }

    private void sendUnknownTransaction(MAP map, ArjunaContext arjunaContext) {
        block2: {
            MAP faultAddressingContext = AddressingHelper.createFaultContext((MAP)map, (String)MessageId.getMessageId());
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            try {
                String message = WSTLogger.i18NLogger.get_wst11_messaging_CoordinatorProcessorImpl_sendUnknownTransaction_1();
                SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, AtomicTransactionConstants.WSAT_ERROR_CODE_UNKNOWN_TRANSACTION_QNAME, message);
                ParticipantClient.getClient().sendSoapFault(faultAddressingContext, (SoapFault)soapFault, instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpecting exception while sending InvalidState", (Object)th);
            }
        }
    }

    private void sendRollback(MAP map, ArjunaContext arjunaContext) {
        block2: {
            String messageId = MessageId.getMessageId();
            MAP responseAddressingContext = AddressingHelper.createOneWayResponseContext((MAP)map, (String)messageId);
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            try {
                ParticipantClient.getClient().sendRollback(null, responseAddressingContext, instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Rollback", (Object)th);
            }
        }
    }

    private static boolean areRecoveryLogEntriesAccountedFor() {
        return XTSATRecoveryManager.getRecoveryManager().isCoordinatorRecoveryStarted();
    }
}

