/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.base.processors.ActivatedObjectProcessor;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.wsarjtx.ArjunaTXConstants;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.client.CompletionInitiatorClient;
import com.arjuna.webservices11.wsat.processors.CompletionCoordinatorProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst11.CompletionCoordinatorParticipant;
import java.text.MessageFormat;
import org.jboss.wsf.common.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;

public class CompletionCoordinatorProcessorImpl
extends CompletionCoordinatorProcessor {
    private final ActivatedObjectProcessor activatedObjectProcessor = new ActivatedObjectProcessor();

    @Override
    public void activateParticipant(CompletionCoordinatorParticipant participant, String identifier) {
        this.activatedObjectProcessor.activateObject((Object)participant, identifier);
    }

    @Override
    public void deactivateParticipant(CompletionCoordinatorParticipant participant) {
        this.activatedObjectProcessor.deactivateObject((Object)participant);
    }

    private CompletionCoordinatorParticipant getParticipant(InstanceIdentifier instanceIdentifier) {
        String identifier = instanceIdentifier != null ? instanceIdentifier.getInstanceIdentifier() : null;
        return (CompletionCoordinatorParticipant)this.activatedObjectProcessor.getObject(identifier);
    }

    @Override
    public void commit(Notification commit, MAP map, ArjunaContext arjunaContext) {
        block10: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            CompletionCoordinatorParticipant participant = this.getParticipant(instanceIdentifier);
            try {
                if (participant != null) {
                    String messageId = MessageId.getMessageId();
                    try {
                        participant.commit();
                    }
                    catch (TransactionRolledBackException trbe) {
                        MAP responseAddressingContext = AddressingHelper.createResponseContext((MAP)map, (String)messageId);
                        CompletionInitiatorClient.getClient().sendAborted(participant.getParticipant(), responseAddressingContext, instanceIdentifier);
                        return;
                    }
                    catch (UnknownTransactionException ute) {
                        MAP faultAddressingContext = AddressingHelper.createFaultContext((MAP)map, (String)messageId);
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_1());
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, (SoapFault)soapFault, instanceIdentifier);
                        return;
                    }
                    catch (SystemException se) {
                        MAP faultAddressingContext = AddressingHelper.createFaultContext((MAP)map, (String)messageId);
                        String pattern = WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_2();
                        String message = MessageFormat.format(pattern, new Object[]{se});
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME, message);
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, (SoapFault)soapFault, instanceIdentifier);
                        return;
                    }
                    catch (Throwable th) {
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev("Unexpected exception thrown from commit:", (Object)th);
                        }
                        MAP faultAddressingContext = AddressingHelper.createFaultContext((MAP)map, (String)MessageId.getMessageId());
                        SoapFault11 soapFault = new SoapFault11(th);
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, (SoapFault)soapFault, instanceIdentifier);
                        return;
                    }
                    MAP responseAddressingContext = AddressingHelper.createResponseContext((MAP)map, (String)messageId);
                    CompletionInitiatorClient.getClient().sendCommitted(participant.getParticipant(), responseAddressingContext, instanceIdentifier);
                    break block10;
                }
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Commit called on unknown participant: {0}", new Object[]{instanceIdentifier});
                }
                MAP faultAddressingContext = AddressingHelper.createFaultContext((MAP)map, (String)MessageId.getMessageId());
                SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_5());
                CompletionInitiatorClient.getClient().sendSoapFault(faultAddressingContext, (SoapFault)soapFault, instanceIdentifier);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void rollback(Notification rollback, MAP map, ArjunaContext arjunaContext) {
        block9: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            CompletionCoordinatorParticipant participant = this.getParticipant(instanceIdentifier);
            try {
                if (participant != null) {
                    String messageId = MessageId.getMessageId();
                    try {
                        participant.rollback();
                    }
                    catch (UnknownTransactionException ute) {
                        MAP faultAddressingContext = AddressingHelper.createFaultContext((MAP)map, (String)messageId);
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_6());
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, (SoapFault)soapFault, instanceIdentifier);
                        return;
                    }
                    catch (SystemException systemException) {
                        MAP faultAddressingContext = AddressingHelper.createFaultContext((MAP)map, (String)messageId);
                        String message = WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_7();
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME, message);
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, (SoapFault)soapFault, instanceIdentifier);
                        return;
                    }
                    catch (Throwable th) {
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev("Unexpected exception thrown from rollback:", (Object)th);
                        }
                        MAP faultAddressingContext = AddressingHelper.createFaultContext((MAP)map, (String)MessageId.getMessageId());
                        SoapFault11 soapFault = new SoapFault11(th);
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, (SoapFault)soapFault, instanceIdentifier);
                        return;
                    }
                    MAP responseAddressingContext = AddressingHelper.createResponseContext((MAP)map, (String)messageId);
                    CompletionInitiatorClient.getClient().sendAborted(participant.getParticipant(), responseAddressingContext, instanceIdentifier);
                    break block9;
                }
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Rollback called on unknown participant: {0}", new Object[]{instanceIdentifier});
                }
                MAP faultAddressingContext = AddressingHelper.createFaultContext((MAP)map, (String)MessageId.getMessageId());
                SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_10());
                CompletionInitiatorClient.getClient().sendSoapFault(faultAddressingContext, (SoapFault)soapFault, instanceIdentifier);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
    }
}

