/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsat.client;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsaddr.EndpointHelper;
import com.arjuna.webservices11.wsaddr.NativeEndpointReference;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.client.WSATClient;
import java.io.IOException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.wsf.common.addressing.MAP;
import org.jboss.wsf.common.addressing.MAPBuilder;
import org.jboss.wsf.common.addressing.MAPBuilderFactory;
import org.jboss.wsf.common.addressing.MAPEndpoint;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionCoordinatorPortType;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;

public class CompletionCoordinatorClient {
    private static final CompletionCoordinatorClient CLIENT = new CompletionCoordinatorClient();
    private String commitAction = null;
    private String rollbackAction = null;
    private MAPEndpoint completionInitiator;
    private MAPEndpoint secureCompletionInitiator;

    private CompletionCoordinatorClient() {
        MAPBuilder builder = MAPBuilderFactory.getInstance().getBuilderInstance();
        this.commitAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Commit";
        this.rollbackAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Rollback";
        String completionInitiatorURIString = ServiceRegistry.getRegistry().getServiceURI("CompletionInitiatorService", false);
        String secureCompletionInitiatorURIString = ServiceRegistry.getRegistry().getServiceURI("CompletionInitiatorService", true);
        this.completionInitiator = builder.newEndpoint(completionInitiatorURIString);
        this.secureCompletionInitiator = builder.newEndpoint(secureCompletionInitiatorURIString);
    }

    public void sendCommit(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint initiator = this.getCompletionInitiator(endpoint);
        AddressingHelper.installFromFaultTo((MAP)map, (MAPEndpoint)initiator, (InstanceIdentifier)identifier);
        CompletionCoordinatorPortType port = this.getPort(endpoint, map, this.commitAction);
        Notification commit = new Notification();
        port.commitOperation(commit);
    }

    public void sendRollback(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint initiator = this.getCompletionInitiator(endpoint);
        AddressingHelper.installFromFaultTo((MAP)map, (MAPEndpoint)initiator, (InstanceIdentifier)identifier);
        CompletionCoordinatorPortType port = this.getPort(endpoint, map, this.rollbackAction);
        Notification rollback = new Notification();
        port.rollbackOperation(rollback);
    }

    MAPEndpoint getCompletionInitiator(W3CEndpointReference participant) {
        NativeEndpointReference nativeRef = (NativeEndpointReference)EndpointHelper.transform(NativeEndpointReference.class, (EndpointReference)participant);
        String address = nativeRef.getAddress();
        if (address.startsWith("https")) {
            return this.secureCompletionInitiator;
        }
        return this.completionInitiator;
    }

    public static CompletionCoordinatorClient getClient() {
        return CLIENT;
    }

    private CompletionCoordinatorPortType getPort(W3CEndpointReference endpoint, MAP map, String action) {
        AddressingHelper.installNoneReplyTo((MAP)map);
        return WSATClient.getCompletionCoordinatorPort(endpoint, action, map);
    }
}

