/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsarjtx.client;

import com.arjuna.schemas.ws._2005._10.wsarjtx.NotificationType;
import com.arjuna.schemas.ws._2005._10.wsarjtx.TerminationParticipantPortType;
import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsaddr.EndpointHelper;
import com.arjuna.webservices11.wsaddr.NativeEndpointReference;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsarjtx.client.WSARJTXClient;
import java.io.IOException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.wsf.common.addressing.MAP;
import org.jboss.wsf.common.addressing.MAPBuilder;
import org.jboss.wsf.common.addressing.MAPBuilderFactory;
import org.jboss.wsf.common.addressing.MAPEndpoint;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class TerminationParticipantClient {
    private static final TerminationParticipantClient CLIENT = new TerminationParticipantClient();
    private String completedAction = null;
    private String closedAction = null;
    private String cancelledAction = null;
    private String faultedAction = null;
    private String soapFaultAction = null;
    private MAPEndpoint terminationCoordinator;
    private MAPEndpoint secureTerminationCoordinator;

    private TerminationParticipantClient() {
        MAPBuilder builder = MAPBuilderFactory.getInstance().getBuilderInstance();
        this.completedAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Completed";
        this.closedAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Closed";
        this.cancelledAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Cancelled";
        this.faultedAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Faulted";
        this.soapFaultAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Fault";
        String terminationCoordinatorURIString = ServiceRegistry.getRegistry().getServiceURI("TerminationCoordinatorService", false);
        String secureTerminationCoordinatorURIString = ServiceRegistry.getRegistry().getServiceURI("TerminationCoordinatorService", true);
        this.terminationCoordinator = builder.newEndpoint(terminationCoordinatorURIString);
        this.secureTerminationCoordinator = builder.newEndpoint(secureTerminationCoordinatorURIString);
    }

    public void sendCompleted(W3CEndpointReference participant, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(participant);
        AddressingHelper.installFromFaultTo((MAP)map, (MAPEndpoint)coordinator, (InstanceIdentifier)identifier);
        TerminationParticipantPortType port = this.getPort(participant, map, identifier, this.completedAction);
        NotificationType completed = new NotificationType();
        port.completedOperation(completed);
    }

    public void sendClosed(W3CEndpointReference participant, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(participant);
        AddressingHelper.installFromFaultTo((MAP)map, (MAPEndpoint)coordinator, (InstanceIdentifier)identifier);
        TerminationParticipantPortType port = this.getPort(participant, map, identifier, this.closedAction);
        NotificationType closed = new NotificationType();
        port.closedOperation(closed);
    }

    public void sendCancelled(W3CEndpointReference participant, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(participant);
        AddressingHelper.installFromFaultTo((MAP)map, (MAPEndpoint)coordinator, (InstanceIdentifier)identifier);
        TerminationParticipantPortType port = this.getPort(participant, map, identifier, this.cancelledAction);
        NotificationType cancelled = new NotificationType();
        port.cancelledOperation(cancelled);
    }

    public void sendFaulted(W3CEndpointReference participant, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(participant);
        AddressingHelper.installFromFaultTo((MAP)map, (MAPEndpoint)coordinator, (InstanceIdentifier)identifier);
        TerminationParticipantPortType port = this.getPort(participant, map, identifier, this.faultedAction);
        NotificationType faulted = new NotificationType();
        port.faultedOperation(faulted);
    }

    public void sendSoapFault(W3CEndpointReference endpoint, MAP map, SoapFault soapFault, InstanceIdentifier identifier) throws SoapFault, IOException {
        AddressingHelper.installNoneReplyTo((MAP)map);
        TerminationParticipantPortType port = this.getPort(endpoint, map, identifier, this.soapFaultAction);
        SoapFault11 soapFault11 = (SoapFault11)soapFault;
        Fault fault = soapFault11.toFault();
        port.faultOperation(fault);
    }

    public void sendSoapFault(SoapFault soapFault, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        TerminationParticipantPortType port = this.getPort(map, identifier, this.soapFaultAction);
        SoapFault11 soapFault11 = (SoapFault11)soapFault;
        Fault fault = soapFault11.toFault();
        port.faultOperation(fault);
    }

    MAPEndpoint getCoordinator(W3CEndpointReference participant) {
        NativeEndpointReference nativeRef = (NativeEndpointReference)EndpointHelper.transform(NativeEndpointReference.class, (EndpointReference)participant);
        String address = nativeRef.getAddress();
        if (address.startsWith("https")) {
            return this.secureTerminationCoordinator;
        }
        return this.terminationCoordinator;
    }

    public static TerminationParticipantClient getClient() {
        return CLIENT;
    }

    private TerminationParticipantPortType getPort(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier, String action) {
        return WSARJTXClient.getTerminationParticipantPort(endpoint, action, map);
    }

    private TerminationParticipantPortType getPort(MAP map, InstanceIdentifier identifier, String action) {
        AddressingHelper.installNoneReplyTo((MAP)map);
        return WSARJTXClient.getTerminationParticipantPort(identifier, action, map);
    }
}

