/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsarjtx.client;

import com.arjuna.schemas.ws._2005._10.wsarjtx.NotificationType;
import com.arjuna.schemas.ws._2005._10.wsarjtx.TerminationCoordinatorPortType;
import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsaddr.EndpointHelper;
import com.arjuna.webservices11.wsaddr.NativeEndpointReference;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsarjtx.client.WSARJTXClient;
import java.io.IOException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.wsf.common.addressing.MAP;
import org.jboss.wsf.common.addressing.MAPBuilder;
import org.jboss.wsf.common.addressing.MAPBuilderFactory;
import org.jboss.wsf.common.addressing.MAPEndpoint;

public class TerminationCoordinatorClient {
    private static final TerminationCoordinatorClient CLIENT = new TerminationCoordinatorClient();
    private String completeAction = null;
    private String closeAction = null;
    private String cancelAction = null;
    private MAPEndpoint terminationParticipant;
    private MAPEndpoint secureTerminationParticipant;

    private TerminationCoordinatorClient() {
        MAPBuilder builder = MAPBuilderFactory.getInstance().getBuilderInstance();
        this.completeAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Complete";
        this.closeAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Close";
        this.cancelAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Cancel";
        String terminationParticipantURIString = ServiceRegistry.getRegistry().getServiceURI("TerminationParticipantService", false);
        String secureTerminationParticipantURIString = ServiceRegistry.getRegistry().getServiceURI("TerminationParticipantService", true);
        this.terminationParticipant = builder.newEndpoint(terminationParticipantURIString);
        this.secureTerminationParticipant = builder.newEndpoint(secureTerminationParticipantURIString);
    }

    public void sendComplete(W3CEndpointReference coordinator, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint participant = this.getParticipant(coordinator);
        AddressingHelper.installFromFaultTo((MAP)map, (MAPEndpoint)participant, (InstanceIdentifier)identifier);
        TerminationCoordinatorPortType port = this.getPort(coordinator, map, identifier, this.completeAction);
        NotificationType complete = new NotificationType();
        port.completeOperation(complete);
    }

    public void sendClose(W3CEndpointReference coordinator, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint participant = this.getParticipant(coordinator);
        AddressingHelper.installFromFaultTo((MAP)map, (MAPEndpoint)participant, (InstanceIdentifier)identifier);
        TerminationCoordinatorPortType port = this.getPort(coordinator, map, identifier, this.closeAction);
        NotificationType close = new NotificationType();
        port.closeOperation(close);
    }

    public void sendCancel(W3CEndpointReference coordinator, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint participant = this.getParticipant(coordinator);
        AddressingHelper.installFromFaultTo((MAP)map, (MAPEndpoint)participant, (InstanceIdentifier)identifier);
        TerminationCoordinatorPortType port = this.getPort(coordinator, map, identifier, this.cancelAction);
        NotificationType cancel = new NotificationType();
        port.cancelOperation(cancel);
    }

    MAPEndpoint getParticipant(W3CEndpointReference coordinator) {
        NativeEndpointReference nativeRef = (NativeEndpointReference)EndpointHelper.transform(NativeEndpointReference.class, (EndpointReference)coordinator);
        String address = nativeRef.getAddress();
        if (address.startsWith("https")) {
            return this.secureTerminationParticipant;
        }
        return this.terminationParticipant;
    }

    public static TerminationCoordinatorClient getClient() {
        return CLIENT;
    }

    private TerminationCoordinatorPortType getPort(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier, String action) {
        AddressingHelper.installNoneReplyTo((MAP)map);
        return WSARJTXClient.getTerminationCoordinatorPort(endpoint, action, map);
    }
}

