/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst11.at;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.exceptions.InvalidActivityException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wscf.exceptions.ProtocolNotRegisteredException;
import com.arjuna.mw.wscf.model.twophase.api.CoordinatorManager;
import com.arjuna.mw.wscf.model.twophase.participants.Participant;
import com.arjuna.mw.wscf.model.twophase.participants.Synchronization;
import com.arjuna.mw.wscf11.model.twophase.CoordinatorManagerFactory;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.ATCoordinator;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.subordinate.SubordinateATCoordinator;
import com.arjuna.mwlabs.wst.at.participants.DurableTwoPhaseCommitParticipant;
import com.arjuna.mwlabs.wst.at.participants.VolatileTwoPhaseCommitParticipant;
import com.arjuna.mwlabs.wst11.at.participants.CompletionCoordinatorImple;
import com.arjuna.mwlabs.wst11.at.participants.CompletionCoordinatorRPCImple;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.AtomicTransactionConstants;
import com.arjuna.webservices11.wsat.processors.CompletionCoordinatorProcessor;
import com.arjuna.webservices11.wsat.processors.CompletionCoordinatorRPCProcessor;
import com.arjuna.wsc.AlreadyRegisteredException;
import com.arjuna.wsc.InvalidProtocolException;
import com.arjuna.wsc.InvalidStateException;
import com.arjuna.wsc.NoActivityException;
import com.arjuna.wsc11.Registrar;
import com.arjuna.wsc11.RegistrarMapper;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.Volatile2PCParticipant;
import com.arjuna.wst11.CompletionCoordinatorParticipant;
import com.arjuna.wst11.stub.Durable2PCStub;
import com.arjuna.wst11.stub.Volatile2PCStub;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;

public class RegistrarImple
implements Registrar {
    private CoordinatorManager _coordManager = null;
    private ConcurrentHashMap _hierarchies = new ConcurrentHashMap();

    public RegistrarImple() throws ProtocolNotRegisteredException, SystemException {
        this._coordManager = CoordinatorManagerFactory.coordinatorManager();
        RegistrarMapper mapper = RegistrarMapper.getFactory();
        mapper.addRegistrar("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Durable2PC", (Registrar)this);
        mapper.addRegistrar("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Volatile2PC", (Registrar)this);
        mapper.addRegistrar("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Completion", (Registrar)this);
        mapper.addRegistrar("http://docs.oasis-open.org/ws-tx/wsat/2006/06/CompletionRPC", (Registrar)this);
    }

    public void install(String protocolIdentifier) {
    }

    public W3CEndpointReference register(W3CEndpointReference participantProtocolService, String protocolIdentifier, InstanceIdentifier instanceIdentifier, boolean isSecure) throws AlreadyRegisteredException, InvalidProtocolException, InvalidStateException, NoActivityException {
        Object tx = this._hierarchies.get(instanceIdentifier.getInstanceIdentifier());
        if (tx instanceof SubordinateATCoordinator) {
            return this.registerWithSubordinate((SubordinateATCoordinator)tx, participantProtocolService, protocolIdentifier, isSecure);
        }
        ActivityHierarchy hier = (ActivityHierarchy)tx;
        if (hier == null) {
            throw new NoActivityException();
        }
        try {
            this._coordManager.resume(hier);
        }
        catch (InvalidActivityException ex) {
            throw new NoActivityException();
        }
        catch (SystemException ex) {
            throw new InvalidProtocolException();
        }
        if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Durable2PC".equals(protocolIdentifier)) {
            String participantId = "D" + new Uid().stringForm();
            try {
                Durable2PCStub participantStub = new Durable2PCStub(participantId, participantProtocolService);
                this._coordManager.enlistParticipant((Participant)new DurableTwoPhaseCommitParticipant((Durable2PCParticipant)participantStub, participantId));
                this._coordManager.suspend();
                return this.getCoordinator(participantId, isSecure);
            }
            catch (Exception ex) {
                throw new InvalidStateException();
            }
        }
        if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Volatile2PC".equals(protocolIdentifier)) {
            String participantId = "V" + new Uid().stringForm();
            try {
                Volatile2PCStub participantStub = new Volatile2PCStub(participantId, participantProtocolService);
                this._coordManager.enlistSynchronization((Synchronization)new VolatileTwoPhaseCommitParticipant((Volatile2PCParticipant)participantStub));
                this._coordManager.suspend();
                return this.getCoordinator(participantId, isSecure);
            }
            catch (Exception ex) {
                throw new InvalidStateException();
            }
        }
        if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Completion".equals(protocolIdentifier)) {
            try {
                CompletionCoordinatorImple participant = new CompletionCoordinatorImple(this._coordManager, hier, true, participantProtocolService);
                CompletionCoordinatorProcessor.getProcessor().activateParticipant((CompletionCoordinatorParticipant)participant, instanceIdentifier.getInstanceIdentifier());
                this._coordManager.suspend();
                return this.getCompletionCoordinator(instanceIdentifier, isSecure);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new InvalidStateException(ex.toString());
            }
        }
        if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06/CompletionRPC".equals(protocolIdentifier)) {
            try {
                CompletionCoordinatorRPCImple participant = new CompletionCoordinatorRPCImple(this._coordManager, hier, true, participantProtocolService);
                CompletionCoordinatorRPCProcessor.getProcessor().activateParticipant((CompletionCoordinatorParticipant)participant, instanceIdentifier.getInstanceIdentifier());
                this._coordManager.suspend();
                return this.getCompletionCoordinatorRPC(instanceIdentifier, isSecure);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new InvalidStateException(ex.toString());
            }
        }
        wstxLogger.i18NLogger.warn_mwlabs_wst_at_Registrar11Imple_1("http://docs.oasis-open.org/ws-tx/wsat/2006/06", protocolIdentifier);
        throw new InvalidProtocolException();
    }

    public void uninstall(String protocolIdentifier) {
    }

    public final void associate() throws Exception {
        String txIdentifier = this._coordManager.identifier().toString();
        ActivityHierarchy hier = this._coordManager.suspend();
        this._hierarchies.put(txIdentifier, hier);
    }

    public final void associate(ATCoordinator transaction) throws Exception {
        String txIdentifier = transaction.get_uid().stringForm();
        this._hierarchies.put(txIdentifier, transaction);
    }

    public final void disassociate(String txIdentifier) throws Exception {
        this._hierarchies.remove(txIdentifier);
    }

    private final W3CEndpointReference registerWithSubordinate(SubordinateATCoordinator theTx, W3CEndpointReference participantProtocolService, String protocolIdentifier, boolean isSecure) throws AlreadyRegisteredException, InvalidProtocolException, InvalidStateException, NoActivityException {
        if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Durable2PC".equals(protocolIdentifier)) {
            String participantId = "D" + new Uid().stringForm();
            try {
                Durable2PCStub participantStub = new Durable2PCStub(participantId, participantProtocolService);
                theTx.enlistParticipant((Participant)new DurableTwoPhaseCommitParticipant((Durable2PCParticipant)participantStub, participantId));
                return this.getCoordinator(participantId, isSecure);
            }
            catch (Exception ex) {
                throw new InvalidStateException();
            }
        }
        if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Volatile2PC".equals(protocolIdentifier)) {
            String participantId = "V" + new Uid().stringForm();
            try {
                Volatile2PCStub participantStub = new Volatile2PCStub(participantId, participantProtocolService);
                theTx.enlistSynchronization((Synchronization)new VolatileTwoPhaseCommitParticipant((Volatile2PCParticipant)participantStub));
                return this.getCoordinator(participantId, isSecure);
            }
            catch (Exception ex) {
                throw new InvalidStateException();
            }
        }
        if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Completion".equals(protocolIdentifier)) {
            throw new InvalidStateException();
        }
        wstxLogger.i18NLogger.warn_mwlabs_wst_at_Registrar11Imple_1("http://docs.oasis-open.org/ws-tx/wsat/2006/06", protocolIdentifier);
        throw new InvalidProtocolException();
    }

    private W3CEndpointReference getCompletionCoordinator(InstanceIdentifier instanceIdentifier, boolean isSecure) {
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        String address = ServiceRegistry.getRegistry().getServiceURI("CompletionCoordinatorService", isSecure);
        builder.serviceName(AtomicTransactionConstants.COMPLETION_COORDINATOR_SERVICE_QNAME);
        builder.endpointName(AtomicTransactionConstants.COMPLETION_COORDINATOR_PORT_QNAME);
        builder.address(address);
        InstanceIdentifier.setEndpointInstanceIdentifier((W3CEndpointReferenceBuilder)builder, (InstanceIdentifier)instanceIdentifier);
        return builder.build();
    }

    private W3CEndpointReference getCompletionCoordinatorRPC(InstanceIdentifier instanceIdentifier, boolean isSecure) {
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        String address = ServiceRegistry.getRegistry().getServiceURI("CompletionCoordinatorRPCService", isSecure);
        builder.serviceName(AtomicTransactionConstants.COMPLETION_COORDINATOR_RPC_SERVICE_QNAME);
        builder.endpointName(AtomicTransactionConstants.COMPLETION_COORDINATOR_RPC_PORT_QNAME);
        builder.address(address);
        InstanceIdentifier.setEndpointInstanceIdentifier((W3CEndpointReferenceBuilder)builder, (InstanceIdentifier)instanceIdentifier);
        return builder.build();
    }

    private W3CEndpointReference getCoordinator(String participantId, boolean isSecure) {
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        String address = ServiceRegistry.getRegistry().getServiceURI("CoordinatorService", isSecure);
        builder.serviceName(AtomicTransactionConstants.COORDINATOR_SERVICE_QNAME);
        builder.endpointName(AtomicTransactionConstants.COORDINATOR_PORT_QNAME);
        builder.address(address);
        InstanceIdentifier.setEndpointInstanceIdentifier((W3CEndpointReferenceBuilder)builder, (String)participantId);
        return builder.build();
    }
}

