/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossts;

import java.util.Collection;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossts.BaseComponent;
import org.rhq.plugins.jbossts.TransactionEngineComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionComponent
extends BaseComponent
implements DeleteResourceFacet {
    private boolean deleted;

    @Override
    protected EmsConnection getEmsConnection() {
        TransactionEngineComponent tm = (TransactionEngineComponent)this.getResourceContext().getParentResourceComponent();
        return tm.getEmsConnection();
    }

    @Override
    public AvailabilityType getAvailability() {
        return this.deleted ? AvailabilityType.DOWN : AvailabilityType.UP;
    }

    public void deleteResource() throws Exception {
        try {
            if (!this.deleted) {
                this.invokeOperation("remove", null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration params) {
        if (!this.deleted) {
            OperationResult res = super.invokeOperation(name, params);
            if (res.getErrorMessage() == null) {
                this.deleted = true;
            }
            return res;
        }
        return new OperationResult("Transaction has already been deleted");
    }

    public Collection<EmsBean> getParticipants() {
        return this.getEmsConnection().queryBeans(this.getResourceContext().getResourceKey() + ",puid=*");
    }
}

