/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossts;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseComponent
implements ResourceComponent,
MeasurementFacet,
OperationFacet {
    private ResourceContext context;

    protected abstract EmsConnection getEmsConnection();

    protected ResourceContext getResourceContext() {
        return this.context;
    }

    public void start(ResourceContext context) throws InvalidPluginConfigurationException {
        this.context = context;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    protected EmsBean getBean() {
        EmsConnection conn = this.getEmsConnection();
        return conn.getBean(this.context.getResourceKey());
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        EmsAttribute[] aa;
        EmsBean bean = this.getBean();
        String[] props = new String[requests.size()];
        MeasurementScheduleRequest[] reqs = requests.toArray(new MeasurementScheduleRequest[requests.size()]);
        for (int i = 0; i < props.length; ++i) {
            props[i] = reqs[i].getName();
        }
        List<String> reqProps = Arrays.asList(props);
        List al = bean.refreshAttributes(reqProps);
        for (EmsAttribute emsAttr : aa = al.toArray(new EmsAttribute[al.size()])) {
            int index = reqProps.indexOf(emsAttr.getName());
            if (index == -1) continue;
            MeasurementScheduleRequest msr = reqs[index];
            if (msr.getDataType().equals((Object)DataType.MEASUREMENT)) {
                report.addData(new MeasurementDataNumeric(msr, Double.valueOf(emsAttr.getValue().toString())));
                continue;
            }
            if (!msr.getDataType().equals((Object)DataType.TRAIT)) continue;
            report.addData(new MeasurementDataTrait(msr, emsAttr.getValue().toString()));
        }
    }

    public OperationResult invokeOperation(String name, Configuration params) {
        OperationResult result = new OperationResult();
        try {
            EmsBean bean = this.getBean();
            EmsOperation op = bean.getOperation(name);
            Object res = op.invoke(new Object[0]);
            result.setSimpleResult("operation returned " + res);
            result.setErrorMessage(null);
        }
        catch (Exception e) {
            result.setErrorMessage(e.getMessage() == null ? e.getClass().getName() : e.getMessage());
        }
        return result;
    }
}

