/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossts;

import java.util.Collection;
import java.util.Collections;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public class TransactionEngineComponent
extends MBeanResourceComponent {
    public static final String OS_BEAN = "jboss.jta:type=ObjectStore";
    public static final String CE_BEAN = "jboss.jta:name=CoordinatorEnvironmentBean";
    public static final String CORE_BEAN = "jboss.jta:name=CoreEnvironmentBean";
    public static final String STATS_PROP = "EnableStatistics";
    public static final String BUILD_ID_PROP = "BuildId";
    public static final String BUILD_VER_PROP = "BuildVersion";

    public Configuration loadResourceConfiguration() {
        Configuration config = new Configuration();
        EmsBean bean1 = this.getEmsConnection().getBean(CE_BEAN);
        EmsBean bean2 = this.getEmsConnection().getBean(CORE_BEAN);
        config.put((Property)new PropertySimple(STATS_PROP, bean1.getAttribute(STATS_PROP).getValue()));
        config.put((Property)new PropertySimple(BUILD_ID_PROP, bean2.getAttribute(BUILD_ID_PROP).getValue()));
        config.put((Property)new PropertySimple(BUILD_VER_PROP, bean2.getAttribute(BUILD_VER_PROP).getValue()));
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        PropertySimple configProp = report.getConfiguration().getSimple(STATS_PROP);
        EmsBean bean = this.getEmsConnection().getBean(CE_BEAN);
        try {
            bean.getAttribute(STATS_PROP).setValue((Object)configProp.getBooleanValue());
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage("Error enabling/disabling statistics: " + e);
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if ("probe".equals(name)) {
            Collection<EmsBean> transactions = this.getTransactions();
            return new OperationResult("Found " + transactions.size() + " transactions");
        }
        return super.invokeOperation(name, parameters);
    }

    public Collection<EmsBean> getTransactions() {
        try {
            EmsOperation op = this.getEmsConnection().getBean(OS_BEAN).getOperation("probe");
            op.invoke(new Object[0]);
            return this.getEmsConnection().queryBeans("jboss.jta:type=ObjectStore,*");
        }
        catch (Exception e) {
            log.info((Object)("MBean query error: " + e));
            return Collections.EMPTY_LIST;
        }
    }
}

