/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.jbossts.jopr;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.jboss.as.integration.jbossts.jopr.JMXClient;
import org.jboss.as.integration.jbossts.jopr.TxnConstants;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxnStoreComponent
extends JMXClient {
    private ObjectName objectName;
    private Collection<ObjectName> transactions;

    @Override
    public void start(ResourceContext context) {
        super.start(context);
        this.objectName = TxnConstants.OS_MBEAN;
        this.transactions = Collections.EMPTY_LIST;
    }

    public Collection<ObjectName> getComponents() {
        QueryExp query = Query.eq(Query.attr("Participant"), Query.value(false));
        try {
            this.log.debug((Object)"Updating view of Transactions");
            this.invokeOperation(this.objectName, "probe", new Object[0]);
            this.transactions = this.conn.queryNames(new ObjectName("jboss.jta:type=ObjectStore,*"), query);
        }
        catch (Exception e) {
            this.log.info((Object)("MBean query error: " + e));
        }
        return this.transactions;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        try {
            if (this.objectName != null) {
                this.getValues(report, requests, this.objectName);
            }
        }
        catch (Exception e) {
            this.log.info((Object)("MBean log entry lookup error: " + e.getMessage()));
        }
    }

    @Override
    public Configuration loadResourceConfiguration() {
        Configuration config = new Configuration();
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        try {
            this.updateConfig(config, TxnConstants.OSENVBEAN, configDef.getPropertiesInGroup("ObjStoreConfiguration"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return config;
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        this.updateResourceConfiguration(report, "ObjStoreConfiguration", TxnConstants.OSENVBEAN);
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration params) {
        String result = "Unsupported operation or invalid Transaction Store";
        if (name.equals("refresh") && this.objectName != null) {
            int sz = this.transactions.size();
            try {
                this.invokeOperation(this.objectName, "probe", new Object[0]);
                result = "Transaction count changed from " + sz + " to " + this.transactions.size();
            }
            catch (Exception e) {
                result = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
            }
        }
        return new OperationResult(result);
    }
}

