/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.jbossts.jopr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.as.integration.jbossts.jopr.TxnBaseComponent;
import org.jboss.as.integration.jbossts.jopr.TxnConstants;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXClient
extends TxnBaseComponent {
    static Map<String, MBeanInfo> mBeanInfo;
    static Map<String, Map<String, MBeanAttributeInfo>> mBeanPropInfo;
    MBeanServerConnection conn;
    ResourceContext context;

    public JMXClient() {
        try {
            this.getMBeanServerConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("MBeanServer connection error: " + e.getMessage());
        }
    }

    @Override
    public void start(ResourceContext context) {
        super.start(context);
        this.context = context;
        this.initMBeanInfo();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests, ObjectName on) throws Exception {
        String[] props = new String[requests.size()];
        MeasurementScheduleRequest[] reqs = requests.toArray(new MeasurementScheduleRequest[requests.size()]);
        for (int i = 0; i < props.length; ++i) {
            props[i] = reqs[i].getName();
        }
        AttributeList al = this.getAttributes(on, false, props);
        Attribute[] aa = al.toArray(new Attribute[al.size()]);
        for (int i = 0; i < aa.length; ++i) {
            if (reqs[i].getDataType().equals((Object)DataType.MEASUREMENT)) {
                report.addData(new MeasurementDataNumeric(reqs[i], Double.valueOf(aa[i].getValue().toString())));
                continue;
            }
            if (!reqs[i].getDataType().equals((Object)DataType.TRAIT)) continue;
            report.addData(new MeasurementDataTrait(reqs[i], aa[i].getValue().toString()));
        }
    }

    @Override
    public Configuration loadResourceConfiguration() {
        return super.loadResourceConfiguration();
    }

    protected void updateConfig(Configuration config, ObjectName on, List<PropertyDefinition> propDefs) throws Exception {
        String[] props = new String[propDefs.size()];
        for (int i = 0; i < propDefs.size(); ++i) {
            props[i] = propDefs.get(i).getName();
        }
        List<Attribute> attrs = this.conn.getAttributes(on, props).asList();
        for (Attribute a : attrs) {
            config.put((Property)new PropertySimple(a.getName(), a.getValue()));
        }
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        this.updateResourceConfiguration(report, "StatsConfiguration", TxnConstants.CEBEAN);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report, String groupName, ObjectName ... beans) {
        Map props = report.getConfiguration().getSimpleProperties();
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        ArrayList<String> errors = new ArrayList<String>();
        List propDefs = configDef.getPropertiesInGroup(groupName);
        for (PropertyDefinition def : propDefs) {
            if (def.isReadOnly() || !props.containsKey(def.getName())) continue;
            MBeanAttributeInfo attrInfo = null;
            ObjectName bean = null;
            for (ObjectName on : beans) {
                Map<String, MBeanAttributeInfo> mbprops = mBeanPropInfo.get(on.getCanonicalName());
                if (mbprops == null || (attrInfo = mbprops.get(def.getName())) == null) continue;
                bean = on;
                break;
            }
            if (bean == null) {
                errors.add("Property " + def.getName() + " in group " + groupName + ": no MBean with that property");
                continue;
            }
            try {
                Attribute a = this.toJMXAttribute(attrInfo, (PropertySimple)props.get(def.getName()));
                AttributeList al = this.setAttributes(bean, a);
                if (al.size() == 1) continue;
                errors.add("Property " + def.getName() + " in group " + groupName + " with MBean name " + bean.getCanonicalName() + ": failed to update");
            }
            catch (Exception e) {
                errors.add("Property " + def.getName() + " in group " + groupName + " with MBean name " + bean.getCanonicalName() + ": " + e.toString());
            }
        }
        if (errors.size() != 0) {
            StringBuilder sb = new StringBuilder();
            String prev = report.getErrorMessage();
            for (String e : errors) {
                sb.append(e).append(System.getProperty("line.separator"));
            }
            this.log.debug((Object)sb);
            if (prev != null) {
                sb.append(prev);
            }
            report.setErrorMessage(sb.toString());
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    Attribute toJMXAttribute(MBeanAttributeInfo mbpropinfo, PropertySimple ps) throws Exception {
        String type = mbpropinfo.getType();
        if (type.startsWith("java.lang.")) {
            type = type.substring("java.lang.".length());
        }
        if (type.equals("String")) {
            return new Attribute(ps.getName(), ps.getStringValue());
        }
        if (type.equalsIgnoreCase("Boolean")) {
            return new Attribute(ps.getName(), ps.getBooleanValue());
        }
        if (type.equalsIgnoreCase("Long")) {
            return new Attribute(ps.getName(), ps.getLongValue());
        }
        if (type.equalsIgnoreCase("int") || type.equalsIgnoreCase("Integer")) {
            return new Attribute(ps.getName(), ps.getIntegerValue());
        }
        if (type.equalsIgnoreCase("Float")) {
            return new Attribute(ps.getName(), ps.getFloatValue());
        }
        if (type.equalsIgnoreCase("Double")) {
            return new Attribute(ps.getName(), ps.getDoubleValue());
        }
        throw new Exception("Unsupported object type");
    }

    private void initMBeanInfo() {
        mBeanInfo = new HashMap<String, MBeanInfo>();
        mBeanPropInfo = new HashMap<String, Map<String, MBeanAttributeInfo>>();
        try {
            for (ObjectName on : this.conn.queryNames(new ObjectName("jboss.jta:name=*"), null)) {
                try {
                    MBeanInfo mbi = this.conn.getMBeanInfo(on);
                    mBeanInfo.put(on.getCanonicalName(), mbi);
                    HashMap<String, MBeanAttributeInfo> mbaimap = new HashMap<String, MBeanAttributeInfo>();
                    for (MBeanAttributeInfo mbai : mbi.getAttributes()) {
                        mbaimap.put(mbai.getName(), mbai);
                    }
                    mBeanPropInfo.put(on.getCanonicalName(), mbaimap);
                }
                catch (Exception e) {
                    System.out.println("MBean info error (" + e.getMessage() + ") for " + on);
                }
            }
        }
        catch (Exception e) {
            System.out.println("MBeanServer connection error for " + e.getMessage());
        }
    }

    MBeanServerConnection getMBeanServerConnection() throws Exception {
        if (this.conn == null) {
            try {
                JMXServiceURL url = new JMXServiceURL(TxnConstants.JMXURL);
                JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
                this.conn = jmxc.getMBeanServerConnection();
            }
            catch (MalformedURLException e) {
                System.out.println("jmx connect exception: " + e);
                throw e;
            }
            catch (IOException e) {
                System.out.println("jmx connect exception: " + e);
                throw e;
            }
        }
        return this.conn;
    }

    Object getAttribute(ObjectName objectName, String attr) throws Exception {
        return this.conn.getAttribute(objectName, attr);
    }

    AttributeList getAttributes(ObjectName on, MBeanAttributeInfo[] mbi) throws Exception {
        String[] attrs = new String[mbi.length];
        for (int i = 0; i < mbi.length; ++i) {
            attrs[i] = mbi[i].getName();
        }
        return this.conn.getAttributes(on, attrs);
    }

    AttributeList getAttributes(ObjectName on, boolean verbose, String ... attrs) throws MalformedObjectNameException, InstanceNotFoundException, IOException, ReflectionException {
        AttributeList attributes = this.conn.getAttributes(on, attrs);
        if (verbose) {
            for (Attribute a : attributes.asList()) {
                System.out.println(a.getName() + " = " + a.getValue());
            }
        }
        return attributes;
    }

    AttributeList setAttributes(ObjectName on, Attribute ... attrs) throws InstanceNotFoundException, IOException, ReflectionException {
        AttributeList attributes = new AttributeList();
        attributes.addAll((Collection<?>)Arrays.asList(attrs));
        return this.conn.setAttributes(on, attributes);
    }

    public MBeanInfo getMBeanInfo(ObjectName on) throws Exception {
        MBeanInfo mbi = mBeanInfo.get(on.getCanonicalName());
        return mbi == null ? this.conn.getMBeanInfo(on) : mbi;
    }

    public Object invokeOperation(ObjectName on, String method, Object ... params) throws Exception {
        return this.conn.invoke(on, method, params, null);
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        try {
            return this.conn.queryMBeans(name, query);
        }
        catch (IOException e) {
            this.log.info((Object)("MBean query error: " + e));
            return Collections.EMPTY_SET;
        }
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        try {
            return this.conn.queryNames(name, query);
        }
        catch (IOException e) {
            this.log.info((Object)("MBean query error: " + e));
            return Collections.EMPTY_SET;
        }
    }

    public Set<ObjectInstance> queryMBeans(String name, QueryExp query) {
        try {
            return this.queryMBeans(new ObjectName(name), query);
        }
        catch (MalformedObjectNameException e) {
            this.log.info((Object)("MBean query error: " + e));
            return Collections.EMPTY_SET;
        }
    }

    public Set<ObjectName> queryNames(String name, QueryExp query) {
        try {
            return this.queryNames(new ObjectName(name), query);
        }
        catch (MalformedObjectNameException e) {
            this.log.info((Object)("MBean query error: " + e));
            return Collections.EMPTY_SET;
        }
    }
}

