/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability;

import com.arjuna.orbportability.ORB;
import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.logging.opLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class Services {
    public static final int CONFIGURATION_FILE = 0;
    public static final int RESOLVE_INITIAL_REFERENCES = 1;
    public static final int NAME_SERVICE = 2;
    public static final int FILE = 3;
    public static final int NAMED_CONNECT = 4;
    public static final int BIND_CONNECT = 5;
    public static final String[] BINDING_SERVICES = new String[]{"CONFIGURATION_FILE", "RESOLVE_INITIAL_REFERENCES", "NAME_SERVICE", "FILE", "NAMED_CONNECT", "BIND_CONNECT"};
    private static final int _bindMethod = Services.bindValue(opPropertyManager.getOrbPortabilityEnvironmentBean().getBindMechanism());
    public static final String nameService = "NameService";
    public static final String transactionService = "TransactionManagerService";
    public static final String otsKind = "OTS";
    private static final String tmpFile = ".tmp";
    private static final String separator = " ";
    private ORB _orb = null;

    public Services(ORB orb) {
        this._orb = orb;
    }

    public Object getService(String serviceName, java.lang.Object[] params) throws InvalidName, IOException, SystemException {
        switch (Services.bindDefault()) {
            case 1: {
                return this.getService(serviceName, params, 1);
            }
            case 2: {
                return this.getService(serviceName, params, 2);
            }
            case 3: {
                return this.getService(serviceName, params, 3);
            }
            case 4: {
                return this.getService(serviceName, params, 4);
            }
        }
        return this.getService(serviceName, params, 0);
    }

    public Object getService(String serviceName, java.lang.Object[] params, int mechanism) throws InvalidName, IOException, SystemException {
        Object objRef = null;
        switch (mechanism) {
            case 1: {
                try {
                    objRef = this._orb.orb().resolve_initial_references(serviceName);
                    break;
                }
                catch (SystemException ex) {
                    throw ex;
                }
                catch (InvalidName exp) {
                    throw exp;
                }
                catch (Exception e) {
                    if (opLogger.loggerI18N.isDebugEnabled()) {
                        opLogger.loggerI18N.warn("com.arjuna.orbportability.Services.resolvereffailed", new java.lang.Object[]{serviceName, e});
                    }
                    throw new InvalidName();
                }
            }
            case 2: {
                String kind = params == null ? null : (String)params[0];
                try {
                    Object nsRef = this._orb.orb().resolve_initial_references(nameService);
                    NamingContext ncRef = NamingContextHelper.narrow((Object)nsRef);
                    NameComponent nc = new NameComponent(serviceName, kind);
                    NameComponent[] path = new NameComponent[]{nc};
                    objRef = ncRef.resolve(path);
                    break;
                }
                catch (SystemException ex) {
                    throw ex;
                }
                catch (UserException e) {
                    throw new InvalidName();
                }
            }
            case 0: {
                LineNumberReader input;
                String cosservicesRoot = opPropertyManager.getOrbPortabilityEnvironmentBean().getInitialReferencesRoot();
                String configLocation = opPropertyManager.getOrbPortabilityEnvironmentBean().getInitialReferencesFile();
                String configFile = cosservicesRoot + File.separatorChar + configLocation;
                try {
                    input = new LineNumberReader(new FileReader(configFile));
                }
                catch (FileNotFoundException e) {
                    if (opLogger.loggerI18N.isDebugEnabled()) {
                        opLogger.loggerI18N.debug("com.arjuna.orbportability.Services.openfailure", new java.lang.Object[]{"Services.getService", configFile});
                    }
                    throw new InvalidName();
                }
                String ior = null;
                try {
                    boolean finished = false;
                    while (ior == null && !finished) {
                        String line = input.readLine();
                        if (line == null) {
                            finished = true;
                            continue;
                        }
                        int occur = line.indexOf(serviceName);
                        if (occur != 0) continue;
                        ior = line.substring(serviceName.length() + 1);
                    }
                    input.close();
                }
                catch (SystemException ex) {
                    input.close();
                    throw ex;
                }
                catch (Exception e) {
                    if (opLogger.loggerI18N.isWarnEnabled()) {
                        opLogger.loggerI18N.warn("com.arjuna.orbportability.Services.unexpectedexception", new java.lang.Object[]{"Services.getService", e});
                    }
                    input.close();
                    throw new UNKNOWN();
                }
                if (ior == null) {
                    if (opLogger.loggerI18N.isWarnEnabled()) {
                        opLogger.loggerI18N.warn("com.arjuna.orbportability.Services.servicenotfound", new java.lang.Object[]{serviceName, configFile});
                    }
                    throw new InvalidName();
                }
                try {
                    objRef = this._orb.orb().string_to_object(ior);
                }
                catch (Exception e) {
                    objRef = null;
                }
                break;
            }
            case 3: {
                try {
                    String fileDir = opPropertyManager.getOrbPortabilityEnvironmentBean().getFileDir();
                    File f = null;
                    f = fileDir != null && fileDir.length() != 0 ? new File(fileDir + File.separator + serviceName) : new File(serviceName);
                    FileInputStream ifile = new FileInputStream(f);
                    int size = (int)f.length();
                    byte[] b = new byte[size];
                    ifile.read(b);
                    ifile.close();
                    String objString = new String(b);
                    objRef = this._orb.orb().string_to_object(objString);
                    objString = null;
                    break;
                }
                catch (SystemException ex) {
                    throw ex;
                }
                catch (FileNotFoundException e) {
                    throw new InvalidName();
                }
            }
            case 4: {
                if (opLogger.loggerI18N.isWarnEnabled()) {
                    opLogger.loggerI18N.warn("com.arjuna.orbportability.Services.unsupportedoption", new java.lang.Object[]{"NAMED_CONNECT"});
                }
                throw new BAD_PARAM();
            }
        }
        return objRef;
    }

    public void registerService(Object objRef, String serviceName, java.lang.Object[] params) throws InvalidName, IOException, SystemException {
        switch (Services.bindDefault()) {
            case 0: {
                this.registerService(objRef, serviceName, params, 0);
                break;
            }
            case 1: {
                this.registerService(objRef, serviceName, params, 1);
                break;
            }
            case 2: {
                this.registerService(objRef, serviceName, params, 2);
                break;
            }
            case 4: {
                this.registerService(objRef, serviceName, params, 4);
                break;
            }
            default: {
                this.registerService(objRef, serviceName, params, 0);
            }
        }
    }

    public void registerService(Object objRef, String serviceName, java.lang.Object[] params, int mechanism) throws InvalidName, IOException, SystemException {
        switch (mechanism) {
            case 1: {
                throw new BAD_PARAM();
            }
            case 2: {
                String kind = params == null ? null : (String)params[0];
                try {
                    Object initServ = this._orb.orb().resolve_initial_references(nameService);
                    NamingContext rootContext = NamingContextHelper.narrow((Object)initServ);
                    NameComponent[] contextName = new NameComponent[]{new NameComponent(serviceName, kind)};
                    rootContext.rebind(contextName, objRef);
                    if (!opLogger.logger.isDebugEnabled()) break;
                    opLogger.logger.debug("Services.registerService - object " + serviceName + " registered with name service.");
                    break;
                }
                catch (InvalidName e) {
                    throw new InvalidName();
                }
                catch (UserException e) {
                    throw new InvalidName();
                }
                catch (SystemException e) {
                    throw e;
                }
            }
            case 0: {
                String cosservicesRoot = opPropertyManager.getOrbPortabilityEnvironmentBean().getInitialReferencesRoot();
                String configLocation = opPropertyManager.getOrbPortabilityEnvironmentBean().getInitialReferencesFile();
                String configFile = cosservicesRoot + File.separatorChar + configLocation;
                LineNumberReader input = null;
                String objString = this._orb.orb().object_to_string(objRef);
                File currFile = null;
                String newFileName = configFile + tmpFile;
                try {
                    currFile = new File(configFile);
                    input = new LineNumberReader(new FileReader(currFile));
                }
                catch (FileNotFoundException e) {
                    if (opLogger.loggerI18N.isDebugEnabled()) {
                        opLogger.loggerI18N.debug("com.arjuna.orbportability.Services.openfailure", new java.lang.Object[]{"Services.registerService", configFile});
                    }
                    currFile = null;
                    input = null;
                    newFileName = configFile;
                }
                File nuFile = new File(newFileName);
                PrintWriter outputFile = new PrintWriter(new FileOutputStream(nuFile), true);
                boolean found = false;
                if (input != null) {
                    String line = null;
                    do {
                        if ((line = input.readLine()) == null) continue;
                        int occur = line.indexOf(serviceName);
                        if (occur == 0) {
                            if (line.substring(serviceName.length() + 1) != null) {
                                found = true;
                                outputFile.println(serviceName + separator + objString);
                            }
                        } else {
                            outputFile.println(line);
                        }
                        outputFile.flush();
                    } while (line != null);
                }
                if (!found) {
                    outputFile.println(serviceName + separator + objString);
                    outputFile.flush();
                }
                outputFile.close();
                if (input != null) {
                    input.close();
                    if (currFile.exists()) {
                        currFile.delete();
                    }
                    nuFile.renameTo(currFile);
                    input = null;
                }
                newFileName = null;
                outputFile = null;
                nuFile = null;
                if (!opLogger.logger.isDebugEnabled()) break;
                opLogger.logger.debug("Services.registerService - object " + serviceName + " registered with configuration file: " + configFile);
                break;
            }
            case 3: {
                String fileDir = opPropertyManager.getOrbPortabilityEnvironmentBean().getFileDir();
                FileOutputStream ofile = null;
                ofile = fileDir != null && fileDir.length() != 0 ? new FileOutputStream(fileDir + File.separator + serviceName) : new FileOutputStream(serviceName);
                String objString = this._orb.orb().object_to_string(objRef);
                byte[] b = objString.getBytes();
                ofile.write(b);
                ofile.close();
                if (!opLogger.logger.isDebugEnabled()) break;
                opLogger.logger.debug("Services.registerService - object " + serviceName + " reference file created: " + fileDir + serviceName);
                break;
            }
            case 4: {
                if (opLogger.loggerI18N.isWarnEnabled()) {
                    opLogger.loggerI18N.warn("com.arjuna.orbportability.Services.optionnotsupported", new java.lang.Object[]{"Services.registerService", "NAMED_CONNECT"});
                }
                throw new BAD_PARAM();
            }
        }
    }

    public final String[] listInitialServices() throws IOException, SystemException {
        int totalSize;
        String[] services = this._orb.orb().list_initial_services();
        String cosservicesRoot = opPropertyManager.getOrbPortabilityEnvironmentBean().getInitialReferencesRoot();
        String configLocation = opPropertyManager.getOrbPortabilityEnvironmentBean().getInitialReferencesFile();
        String configFile = cosservicesRoot + File.separatorChar + configLocation;
        LineNumberReader input = null;
        try {
            input = new LineNumberReader(new FileReader(new File(configFile)));
        }
        catch (FileNotFoundException e) {
            input = null;
        }
        Vector<String> otherServices = new Vector<String>();
        if (input != null) {
            String line = null;
            do {
                if ((line = input.readLine()) == null) continue;
                int index = line.indexOf(separator);
                if (index != -1) {
                    otherServices.add(new String(line.substring(0, index)));
                    continue;
                }
                if (!opLogger.loggerI18N.isWarnEnabled()) continue;
                opLogger.loggerI18N.warn("com.arjuna.orbportability.Services.suspectentry", new java.lang.Object[]{"Services.listInitialServices", line});
            } while (line != null);
        }
        String[] completeServices = null;
        int n = totalSize = services == null ? otherServices.size() : services.length + otherServices.size();
        if (totalSize > 0) {
            int index = 0;
            completeServices = new String[totalSize];
            if (services.length > 0) {
                for (index = 0; index < services.length; ++index) {
                    completeServices[index] = services[index];
                }
            }
            for (int j = index; j < otherServices.size(); ++j) {
                completeServices[j + index] = (String)otherServices.elementAt(j);
            }
        }
        return completeServices;
    }

    public static final String bindString(int bindValue) {
        switch (bindValue) {
            case 0: {
                return "CONFIGURATION_FILE";
            }
            case 1: {
                return "RESOLVE_INITIAL_REFERENCES";
            }
            case 2: {
                return "NAME_SERVICE";
            }
            case 3: {
                return "FILE";
            }
            case 4: {
                return "NAMED_CONNECT";
            }
            case 5: {
                return "BIND_CONNECT";
            }
        }
        return "Unknown";
    }

    public static final int bindValue(String bindString) {
        int bindValue = -1;
        for (int count = 0; count < BINDING_SERVICES.length; ++count) {
            if (!BINDING_SERVICES[count].equalsIgnoreCase(bindString)) continue;
            bindValue = count;
        }
        return bindValue;
    }

    public static final int getResolver() {
        int resolver = Services.bindDefault();
        String resolveService = opPropertyManager.getOrbPortabilityEnvironmentBean().getResolveService();
        if (resolveService != null) {
            if (resolveService.compareTo("NAME_SERVICE") == 0) {
                resolver = 2;
            } else if (resolveService.compareTo("BIND_CONNECT") == 0) {
                resolver = 5;
            } else if (resolveService.compareTo("FILE") == 0) {
                resolver = 3;
            } else if (resolveService.compareTo("RESOLVE_INITIAL_REFERENCES") == 0) {
                resolver = 1;
            }
        }
        return resolver;
    }

    private static final synchronized int bindDefault() {
        if (_bindMethod == -1 && opLogger.loggerI18N.isWarnEnabled()) {
            opLogger.loggerI18N.warn("com.arjuna.orbportability.common.Configuration.bindDefault.invalidbind", new java.lang.Object[]{"com.arjuna.orbportability.common.Configuration.bindDefault()"});
        }
        return _bindMethod;
    }
}

