/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.orbspecific.jacorb.interceptors.interposition;

import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.jts.common.InterceptorInfo;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.TransactionalObjectHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

class InterpositionServerRequestInterceptorImpl
extends LocalObject
implements ServerRequestInterceptor {
    private Codec _codec;
    private int _dataSlot;

    public InterpositionServerRequestInterceptorImpl(int dataSlot, Codec codec) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("InterpositionServerRequestInterceptorImpl ( " + dataSlot + " )");
        }
        this._dataSlot = dataSlot;
        this._codec = codec;
    }

    public String name() {
        return "OTS_Interposition";
    }

    public void receive_request_service_contexts(ServerRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("InterpositionServerRequestInterceptorImpl::receive_request_service_contexts ( " + request_info.operation() + " )");
        }
        try {
            try {
                if (!InterceptorInfo.getAlwaysPropagate() && !request_info.target_is_a(TransactionalObjectHelper.id())) {
                    throw new BAD_PARAM();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                ServiceContext serviceContext = null;
                try {
                    serviceContext = request_info.get_request_service_context(-559038737);
                }
                catch (BAD_PARAM bp) {
                    serviceContext = null;
                }
                if (serviceContext != null) {
                    Any receivedData = this._codec.decode_value(serviceContext.context_data, PropagationContextHelper.type());
                    request_info.set_slot(this._dataSlot, receivedData);
                } else if (InterceptorInfo.getNeedTranContext()) {
                    throw new TRANSACTION_REQUIRED();
                }
            }
            catch (TRANSACTION_REQUIRED ex) {
                throw ex;
            }
            catch (Exception e) {
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
    }

    public void receive_request(ServerRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("InterpositionServerRequestInterceptorImpl.receive_request ( " + request_info.operation() + " )");
        }
    }

    public void send_reply(ServerRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("InterpositionServerRequestInterceptorImpl::send_reply ( " + request_info.operation() + " )");
        }
        try {
            this.suspendContext(request_info);
        }
        catch (SystemException ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.interposition.srie", new Object[]{"InterpositionServerRequestInterceptorImpl::send_reply", ex}, ex);
            }
            throw ex;
        }
        catch (Exception e) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.interposition.srie", new Object[]{"InterpositionServerRequestInterceptorImpl::send_reply", e});
            }
            throw new BAD_OPERATION();
        }
    }

    public void send_exception(ServerRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("InterpositionServerRequestInterceptorImpl::send_exception ( " + request_info.operation() + " )");
        }
        try {
            this.suspendContext(request_info);
        }
        catch (SystemException ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.interposition.srie", new Object[]{"InterpositionServerRequestInterceptorImpl::send_exception", ex});
            }
            throw ex;
        }
        catch (Exception e) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.interposition.srie", new Object[]{"InterpositionServerRequestInterceptorImpl::send_exception", e});
            }
            throw new BAD_OPERATION();
        }
    }

    public void send_other(ServerRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("InterpositionServerRequestInterceptorImpl::send_other ( " + request_info.operation() + " )");
        }
        try {
            this.suspendContext(request_info);
        }
        catch (SystemException ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.interposition.srie", new Object[]{"InterpositionServerRequestInterceptorImpl::send_other", ex});
            }
            throw ex;
        }
        catch (Exception e) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.interposition.srie", new Object[]{"InterpositionServerRequestInterceptorImpl::send_other", e});
            }
            throw new BAD_OPERATION();
        }
    }

    private void suspendContext(ServerRequestInfo request_info) throws SystemException, InvalidSlot {
        Any data;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("InterpositionServerRequestInterceptorImpl.suspendContext ( " + request_info.operation() + " )");
        }
        if ((data = request_info.get_slot(this._dataSlot)) != null && data.type().kind().value() != 0) {
            String threadId = null;
            try {
                threadId = data.extract_string();
                if (threadId != null) {
                    ControlWrapper ctx = OTSImpleManager.current().contextManager().popAction(threadId);
                    OTSImpleManager.current().contextManager().purgeActions(threadId);
                }
            }
            catch (BAD_OPERATION bex) {
                // empty catch block
            }
            request_info.set_slot(this._dataSlot, null);
        }
    }

    public void destroy() {
    }
}

