/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore;

import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class BaseTransaction {
    private static boolean _supportSubtransactions = false;
    private static ThreadLocal<Integer> _timeouts = new ThreadLocal();

    public void begin() throws NotSupportedException, SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug("BaseTransaction.begin");
        }
        if (!jtaPropertyManager.getJTAEnvironmentBean().isSupportSubtransactions()) {
            try {
                this.checkTransactionState();
            }
            catch (IllegalStateException e1) {
                NotSupportedException notSupportedException = new NotSupportedException(e1.getMessage());
                notSupportedException.initCause((Throwable)e1);
                throw notSupportedException;
            }
            catch (Exception e2) {
                SystemException systemException = new SystemException(e2.toString());
                systemException.initCause((Throwable)e2);
                throw systemException;
            }
        }
        Integer value = _timeouts.get();
        int v = 0;
        v = value != null ? value : TxControl.getDefaultTimeout();
        TransactionImple.putTransaction(new TransactionImple(v));
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug("BaseTransaction.commit");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            throw new IllegalStateException("BaseTransaction.commit - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.notx"));
        }
        theTransaction.commitAndDisassociate();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug("BaseTransaction.rollback");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            throw new IllegalStateException("BaseTransaction.rollback - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.notx"));
        }
        theTransaction.rollbackAndDisassociate();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug("BaseTransaction.setRollbackOnly");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.nosuchtx"));
        }
        theTransaction.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug("BaseTransaction.getStatus");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            return 6;
        }
        return theTransaction.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds >= 0) {
            _timeouts.set(new Integer(seconds));
        }
    }

    public int getTimeout() throws SystemException {
        Integer value = _timeouts.get();
        if (value != null) {
            return value;
        }
        return 0;
    }

    public String toString() {
        TransactionImple theTransaction = TransactionImple.getTransaction();
        if (theTransaction == null) {
            return "Transaction: unknown";
        }
        return "Transaction: " + theTransaction;
    }

    public TransactionImple createSubordinate() throws NotSupportedException, SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug("BaseTransaction.createSubordinate");
        }
        try {
            this.checkTransactionState();
        }
        catch (IllegalStateException e1) {
            NotSupportedException notSupportedException = new NotSupportedException();
            notSupportedException.initCause((Throwable)e1);
            throw notSupportedException;
        }
        catch (Exception e2) {
            SystemException systemException = new SystemException(e2.toString());
            systemException.initCause((Throwable)e2);
            throw systemException;
        }
        Integer value = _timeouts.get();
        int v = 0;
        if (value != null) {
            v = value;
        }
        return new com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple(v);
    }

    protected BaseTransaction() {
    }

    final void checkTransactionState() throws IllegalStateException, SystemException {
        TransactionImple theTransaction = TransactionImple.getTransaction();
        if (theTransaction == null) {
            return;
        }
        if (theTransaction.getStatus() != 6 && !jtaPropertyManager.getJTAEnvironmentBean().isSupportSubtransactions()) {
            throw new IllegalStateException("BaseTransaction.checkTransactionState - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.alreadyassociated"));
        }
    }

    static {
        _supportSubtransactions = jtaPropertyManager.getJTAEnvironmentBean().isSupportSubtransactions();
    }
}

