/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.state;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.io.PrintWriter;

public class OutputObjectState
extends OutputBuffer {
    private Uid bufferUid;
    private String imageType;

    public OutputObjectState() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("OutputObjectState::OutputObjectState()");
        }
        this.bufferUid = new Uid();
        this._valid = this.bufferUid.valid();
        this.imageType = null;
    }

    public OutputObjectState(OutputObjectState copyFrom) {
        super(copyFrom);
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("OutputObjectState::OutputObjectState(" + copyFrom + ")");
        }
        try {
            this.bufferUid = new Uid(copyFrom.bufferUid);
            this._valid = this.bufferUid.valid();
            this.imageType = new String(copyFrom.imageType);
        }
        catch (Exception ex) {
            this._valid = false;
        }
    }

    public OutputObjectState(InputObjectState copyFrom) {
        super(copyFrom.buffer());
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("OutputObjectState::OutputObjectState(" + copyFrom + ")");
        }
        try {
            this.bufferUid = new Uid(copyFrom.stateUid());
            this._valid = this.bufferUid.valid();
            this.imageType = new String(copyFrom.type());
        }
        catch (Exception ex) {
            this._valid = false;
        }
    }

    public OutputObjectState(Uid newUid, String tName) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("OutputObjectState::OutputObjectState(" + newUid + ", " + tName + ")");
        }
        this.bufferUid = new Uid(newUid);
        this._valid = this.bufferUid.valid();
        this.imageType = tName == null ? null : new String(tName);
    }

    public OutputObjectState(Uid newUid, String tName, byte[] buffer) {
        super(buffer);
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("OutputObjectState::OutputObjectState(" + newUid + ", " + tName + ")");
        }
        this.bufferUid = new Uid(newUid);
        this._valid = this.bufferUid.valid();
        this.imageType = tName == null ? null : new String(tName);
    }

    public final boolean notempty() {
        return this.length() > 0;
    }

    public final int size() {
        return this.length();
    }

    public final Uid stateUid() {
        return this.bufferUid;
    }

    public final String type() {
        return this.imageType;
    }

    @Override
    public void print(PrintWriter strm) {
        strm.println("OutputObjectState Uid   : " + this.bufferUid + "\n");
        if (this.imageType != null) {
            strm.println("OutputObjectState Type  : " + this.imageType + "\n");
        } else {
            strm.println("OutputObjectState Type  : null\n");
        }
        strm.println("OutputObjectState Size  : " + this.size() + "\n");
        strm.println("OutputObjectState Buffer: ");
        super.print(strm);
    }

    public String toString() {
        String val = "OutputObjectState Uid   : " + this.bufferUid + "\n";
        val = this.imageType != null ? val + "OutputObjectState Type  : " + this.imageType + "\n" : val + "OutputObjectState Type  : null\n";
        val = val + "OutputObjectState Size  : " + this.size() + "\n";
        val = val + "OutputObjectState Buffer: ";
        return val;
    }

    public synchronized void copy(OutputObjectState objstate) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("OutputObjectState::copy for " + this.bufferUid);
        }
        super.copy(objstate);
        this.bufferUid = new Uid(objstate.bufferUid);
        this._valid = this.bufferUid.valid();
        this.imageType = objstate.imageType == null ? null : new String(objstate.imageType);
    }

    @Override
    public synchronized void packInto(OutputBuffer buff) throws IOException {
        buff.packString(this.imageType);
        UidHelper.packInto(this.bufferUid, buff);
        super.packInto(buff);
    }
}

