/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.BaseStore;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.TxLog;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import java.io.File;
import java.io.IOException;
import java.io.SyncFailedException;

public abstract class ObjectStore
implements BaseStore,
ParticipantStore,
RecoveryStore,
TxLog {
    protected int shareStatus = arjPropertyManager.getObjectStoreEnvironmentBean().getShare();
    private String _objectStoreRoot = arjPropertyManager.getObjectStoreEnvironmentBean().getLocalOSRoot();
    private String _objectStoreDir = arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreDir();

    @Override
    public boolean allObjUids(String s, InputObjectState buff) throws ObjectStoreException {
        return this.allObjUids(s, buff, -1);
    }

    @Override
    public void sync() throws SyncFailedException, ObjectStoreException {
    }

    public String locateStore(String localOSRoot) throws ObjectStoreException {
        if (this._objectStoreRoot == null) {
            this._objectStoreRoot = arjPropertyManager.getObjectStoreEnvironmentBean().getLocalOSRoot();
        }
        if (this._objectStoreDir == null) {
            this._objectStoreDir = arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreDir();
            if (this._objectStoreDir == null || this._objectStoreDir.length() == 0) {
                throw new ObjectStoreException("object store location property not set.");
            }
            if (!this._objectStoreDir.endsWith(File.separator)) {
                this._objectStoreDir = this._objectStoreDir + File.separator;
            }
            this._objectStoreDir = this._objectStoreDir + this.getClass().getSimpleName();
        }
        String toReturn = null;
        if (localOSRoot == null || localOSRoot.length() == 0) {
            localOSRoot = this._objectStoreRoot != null && this._objectStoreRoot.length() > 0 ? this._objectStoreRoot : "defaultStore" + File.separator;
        }
        if (localOSRoot != null && localOSRoot.length() > 0) {
            toReturn = this._objectStoreDir + File.separator + localOSRoot;
        }
        if (!toReturn.endsWith(File.separator)) {
            toReturn = toReturn + File.separator;
        }
        return toReturn;
    }

    public boolean fullCommitNeeded() {
        return true;
    }

    @Override
    public boolean isType(Uid u, String tn, int st) throws ObjectStoreException {
        return this.currentState(u, tn) == st;
    }

    public void initialise(Uid u, String tn) {
    }

    public void pack(OutputBuffer buff) throws IOException {
    }

    public void unpack(InputBuffer buff) throws IOException {
    }

    public final int shareState() {
        return this.shareStatus;
    }

    public final String storeDir() {
        return this._objectStoreDir;
    }

    public final String storeRoot() {
        return this._objectStoreRoot;
    }

    protected ObjectStore() {
        this(13);
    }

    protected ObjectStore(int ss) {
        this.shareStatus = ss;
    }

    protected abstract boolean supressEntry(String var1);

    protected String revealedId(String name) {
        return name;
    }
}

