/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc. and/or its affiliates,
 * and individual contributors as indicated by the @author tags.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2010,
 * @author JBoss, by Red Hat.
 */
package com.arjuna.ats.tsmx.logging;

import org.jboss.logging.Logger;

import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * i18n log messages for the tsmx module.
 * This class is autogenerated. Don't mess with it.
 *
 * @author Jonathan Halliday (jonathan.halliday@redhat.com) 2010-06
 */
public class tsmxI18NLoggerImpl implements tsmxI18NLogger {

	private final Logger logger;

	tsmxI18NLoggerImpl(Logger logger) {
		this.logger = logger;
	}

	public void error_TransactionServiceMX_failedtoregistermbean(String arg0, Throwable arg1) {
		logger.logv(ERROR, arg1, "ARJUNA-30001 Failed to register MBean {0}", arg0);
	}

	public void error_TransactionServiceMX_failedtounregistermbean(String arg0, Throwable arg1) {
		logger.logv(ERROR, arg1, "ARJUNA-30002 Failed to unregister MBean {0}", arg0);
	}

	public void warn_TransactionServiceMX_mbeanalreadyregistered(String arg0) {
		logger.logv(WARN, "ARJUNA-30003 MBean {0} already registered", arg0);
	}

	public void error_toolsClassLoader_invalidjar(Throwable arg0) {
		logger.logv(ERROR, arg0, "ARJUNA-30004 Error reading tool jar", (Object)null);
	}

	public void error_toolsClassLoader_invalidurl(String arg0, Throwable arg1) {
		logger.logv(ERROR, arg1, "ARJUNA-30005 The URL is invalid {0}", arg0);
	}

}
