/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc. and/or its affiliates,
 * and individual contributors as indicated by the @author tags.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2010,
 * @author JBoss, by Red Hat.
 */
package com.arjuna.ats.jta.logging;

import com.arjuna.ats.arjuna.common.Uid;
import org.jboss.logging.Logger;

import java.text.MessageFormat;

import static org.jboss.logging.Logger.Level.*;

/**
 * i18n log messages for the jta module.
 * This class is autogenerated. Don't mess with it.
 *
 * @author Jonathan Halliday (jonathan.halliday@redhat.com) 2010-06
 */
public class jtaI18NLoggerImpl implements jtaI18NLogger {

	private final Logger logger;

	jtaI18NLoggerImpl(Logger logger) {
		this.logger = logger;
	}

	public void warn_recovery_alluids() {
		logger.logv(WARN, "ARJUNA-16001 could not get all object Uids.", (Object)null);
	}

	public void warn_recovery_cannotadd() {
		logger.logv(WARN, "ARJUNA-16002 Cannot add resource to table: no XID value available.", (Object)null);
	}

	public void warn_recovery_constfail(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-16004 XARecoveryModule setup failed", (Object)null);
	}

	public void warn_recovery_failedtorecover(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-16005 {0} - failed to recover XAResource. status is ${1}", arg0, arg1);
	}

	public void warn_recovery_forgetfailed(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-16006 {0} - forget threw exception", arg0);
	}

	public void warn_recovery_generalrecoveryerror(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-16008 {0} - caught exception", arg0);
	}

	public void warn_recovery_getxaresource(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-16009 Caught:", (Object)null);
	}

	public void info_recovery_firstpass(String arg0) {
		logger.logv(INFO, "ARJUNA-16010 {0} - first pass", arg0);
	}

	public void info_recovery_rollingback(String arg0) {
		logger.logv(INFO, "ARJUNA-16013 Rolling back {0}", arg0);
	}

	public void info_recovery_secondpass(String arg0) {
		logger.logv(INFO, "ARJUNA-16015 {0} - second pass", arg0);
	}

	public void info_recovery_notaxid(String arg0) {
		logger.logv(INFO, "ARJUNA-16016 {0} not an Arjuna XID", arg0);
	}

	public void info_recovery_noxanodes() {
		logger.logv(INFO, "ARJUNA-16017 No XA recovery nodes specified. May not recover orphans.", (Object)null);
	}

	public void warn_recovery_objstoreerror(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-16018 XARecoveryModule periodicWork failed", (Object)null);
	}

	public void warn_recovery_periodicfirstpass(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-16019 {0} exception", arg0);
	}

	public void warn_recovery_periodicsecondpass(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-16020 {0} exception", arg0);
	}

	public void info_recovery_recoverydelayed(Uid arg0, String arg1) {
		logger.logv(INFO, "ARJUNA-16021 JTA recovery delayed for {0}; got status {1} so waiting for coordinator driven recovery", arg0, arg1);
	}

	public void warn_recovery_recoveryerror(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-16022 Recovery threw:", (Object)null);
	}

	public void warn_recovery_recoveryfailed(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-16023 JTA failed to recovery {0}; got status {1}", arg0, arg1);
	}

	public void warn_recovery_unexpectedrecoveryerror(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-16025 Unexpected recovery error", (Object)null);
	}

	public void warn_recovery_xarecovery1(String arg0, String arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-16027 {0} got XA exception {1}", arg0, arg1);
	}

	public void warn_recovery_xarecovery2(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-16028 {0} got exception", arg0);
	}

	public void warn_resources_arjunacore_SynchronizationImple(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-16029 SynchronizationImple.afterCompletion - failed for {0} with exception", arg0);
	}

	public String get_resources_arjunacore_XAOnePhaseResource_pack() {
		return "ARJUNA-16030 XAOnePhaseResource.pack failed to serialise resource";
	}

	public void warn_resources_arjunacore_XAOnePhaseResource_rollbackexception(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-16031 XAOnePhaseResource.rollback for {0} failed with exception", arg0);
	}

	public String get_resources_arjunacore_XAOnePhaseResource_unpack() {
		return "ARJUNA-16032 failed to deserialise resource";
	}

	public String get_resources_arjunacore_XAOnePhaseResource_unpackType(String arg0) {
		return MessageFormat.format("ARJUNA-16033 Unknown recovery type {0}", arg0);
	}

	public void info_resources_arjunacore_assumecomplete(String arg0) {
		logger.logv(INFO, "ARJUNA-16034 Being told to assume complete on Xid {0}", arg0);
	}

	public void warn_resources_arjunacore_commitnulltx(String arg0) {
		logger.logv(WARN, "ARJUNA-16035 {0} - null transaction!", arg0);
	}

	public void warn_resources_arjunacore_commitxaerror(String arg0, String arg1, String arg2, Throwable arg3) {
		logger.logv(WARN, arg3, "ARJUNA-16036 commit on {0} ({1}) failed with exception ${2}", arg0, arg1, arg2);
	}

	public void warn_resources_arjunacore_norecoveryxa(String arg0) {
		logger.logv(WARN, "ARJUNA-16037 Could not find new XAResource to use for recovering non-serializable XAResource {0}", arg0);
	}

	public void warn_resources_arjunacore_noresource(String arg0) {
		logger.logv(WARN, "ARJUNA-16038 No XAResource to recover {0}", arg0);
	}

	public void warn_resources_arjunacore_opcerror(String arg0, String arg1, String arg2, Throwable arg3) {
		logger.logv(WARN, arg3, "ARJUNA-16039 onePhaseCommit on {0} ({1}) failed with exception {2}", arg0, arg1, arg2);
	}

	public void warn_resources_arjunacore_opcnulltx(String arg0) {
		logger.logv(WARN, "ARJUNA-16040 {0} - null transaction!", arg0);
	}

	public void warn_resources_arjunacore_preparefailed(String arg0, String arg1, String arg2, Throwable arg3) {
		logger.logv(WARN, arg3, "ARJUNA-16041 prepare on {0} ({1}) failed with exception {2}", arg0, arg1, arg2);
	}

	public void warn_resources_arjunacore_preparenulltx(String arg0) {
		logger.logv(WARN, "ARJUNA-16042 {0} - null transaction!", arg0);
	}

	public void warn_resources_arjunacore_restorestate(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-16043 Exception on attempting to restore XAResource", (Object)null);
	}

	public void warn_resources_arjunacore_restorestateerror(String arg0, String arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-16044 An error occurred during restore_state for XAResource {0} and transaction {1}", arg0, arg1);
	}

	public void warn_resources_arjunacore_rollbackerror(String arg0, String arg1, String arg2, Throwable arg3) {
		logger.logv(WARN, arg3, "ARJUNA-16045 attempted rollback of {0} ({1}) failed with exception code {2}", arg0, arg1, arg2);
	}

	public void warn_resources_arjunacore_rollbacknulltx(String arg0) {
		logger.logv(WARN, "ARJUNA-16046 {0} - null transaction!", arg0);
	}

	public void warn_resources_arjunacore_savestate() {
		logger.logv(WARN, "ARJUNA-16047 Could not serialize a Serializable XAResource!", (Object)null);
	}

	public void warn_resources_arjunacore_savestateerror(String arg0, String arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-16048 An error occurred during save_state for XAResource {0} and transaction {1}", arg0, arg1);
	}

	public void warn_resources_arjunacore_setvalue(String arg0) {
		logger.logv(WARN, "ARJUNA-16049 {0} called illegally.", arg0);
	}

	public String get_transaction_arjunacore_alreadyassociated() {
		return "ARJUNA-16051 thread is already associated with a transaction!";
	}

	public String get_transaction_arjunacore_commitwhenaborted() {
		return "ARJUNA-16053 Could not commit transaction.";
	}

	public String get_transaction_arjunacore_couldnotregister() {
		return "ARJUNA-16054 could not register transaction";
	}

	public void warn_transaction_arjunacore_delistgeneral(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-16055 {0} caught exception", arg0);
	}

	public void warn_transaction_arjunacore_delistresource(String arg0, String arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-16056 {0} - caught exception during delist : {1}", arg0, arg1);
	}

	public void warn_transaction_arjunacore_endsuspendfailed1() {
		logger.logv(WARN, "ARJUNA-16058 Ending suspended RMs failed when rolling back the transaction!", (Object)null);
	}

	public String get_transaction_arjunacore_endsuspendfailed2() {
		return "ARJUNA-16059 Ending suspended RMs failed when rolling back the transaction, but transaction rolled back.";
	}

	public void warn_transaction_arjunacore_enlisterror(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-16060 {0} - caught: {1}", arg0, arg1);
	}

	public void warn_transaction_arjunacore_enliststarterror(String arg0, String arg1, String arg2, Throwable arg3) {
		logger.logv(WARN, arg3, "ARJUNA-16061 {0} - XAResource.start returned: {2} for {1}", arg0, arg1, arg2);
	}

	public String get_transaction_arjunacore_illresstate() {
		return "ARJUNA-16062 illegal resource state";
	}

	public String get_transaction_arjunacore_inactive() {
		return "ARJUNA-16063 The transaction is not active!";
	}

	public String get_transaction_arjunacore_invalidstate() {
		return "ARJUNA-16064 The transaction is in an invalid state!";
	}

	public void error_transaction_arjunacore_jca_SubordinationManager_importerfailure(Throwable arg0) {
		logger.logv(ERROR, arg0, "ARJUNA-16066 Failed to create instance of TransactionImporter", (Object)null);
	}

	public void error_transaction_arjunacore_jca_SubordinationManager_terminatorfailure(Throwable arg0) {
		logger.logv(ERROR, arg0, "ARJUNA-16067 Failed to create instance of XATerminator", (Object)null);
	}

	public String get_transaction_arjunacore_jca_busy() {
		return "ARJUNA-16068 Work already active!";
	}

	public void warn_transaction_arjunacore_lastResourceOptimisationInterface(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-16069 failed to load Last Resource Optimisation Interface {0}", arg0);
	}

	public void warn_transaction_arjunacore_markrollback(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-16070 {0} - could not mark {0} as rollback only", arg0, arg1);
	}

	public void warn_transaction_arjunacore_newtmerror(String arg0, String arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-16071 {0} caught XAException: {0}", arg0, arg1);
	}

	public String get_transaction_arjunacore_nosuchtx() {
		return "ARJUNA-16072 No such transaction!";
	}

	public void warn_transaction_arjunacore_notatomicaction() {
		logger.logv(WARN, "ARJUNA-16073 Current transaction is not an AtomicAction!", (Object)null);
	}

	public String get_transaction_arjunacore_notx() {
		return "ARJUNA-16074 no transaction!";
	}

	public String get_transaction_arjunacore_nullparam() {
		return "ARJUNA-16075 null synchronization parameter!";
	}

	public String get_transaction_arjunacore_nullres() {
		return "ARJUNA-16076 Resource paramater is null!";
	}

	public String get_transaction_arjunacore_ressuspended() {
		return "ARJUNA-16078 resource already suspended.";
	}

	public String get_transaction_arjunacore_rollbackstatus() {
		return "ARJUNA-16079 Transaction rollback status is:";
	}

	public String get_transaction_arjunacore_subordinate_invalidstate() {
		return "ARJUNA-16080 Not allowed to terminate subordinate transaction directly.";
	}

	public String get_transaction_arjunacore_syncrollbackexception() {
		return "ARJUNA-16081 The transaction implementation threw a RollbackException";
	}

	public String get_transaction_arjunacore_syncsnotallowed() {
		return "ARJUNA-16082 Synchronizations are not allowed! Transaction status is";
	}

	public String get_transaction_arjunacore_syncwhenaborted() {
		return "ARJUNA-16083 Can't register synchronization because the transaction is in aborted state";
	}

	public String get_transaction_arjunacore_systemexception() {
		return "ARJUNA-16084 The transaction implementation threw a SystemException";
	}

	public void warn_transaction_arjunacore_threadexception(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-16085 Caught the following error", (Object)null);
	}

	public void warn_transaction_arjunacore_timeouterror(String arg0, String arg1, String arg2, Throwable arg3) {
		logger.logv(WARN, arg3, "ARJUNA-16086 {0} setTransactionTimeout on XAResource {1} threw: {2}", arg0, arg1, arg2);
	}

	public void warn_transaction_arjunacore_unknownresource(String arg0) {
		logger.logv(WARN, "ARJUNA-16087 {0} - unknown resource", arg0);
	}

	public void warn_transaction_arjunacore_xaenderror(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-16088 Could not call end on a suspended resource!", (Object)null);
	}

	public void warn_transaction_arjunacore_xastart(String arg0, String arg1, String arg2, Throwable arg3) {
		logger.logv(WARN, arg3, "ARJUNA-16089 {0} - caught: {2} for {1}", arg0, arg1, arg2);
	}

	public void warn_TransactionManager_jndifailure(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-16091 Failed to lookup transaction manager in JNDI context", (Object)null);
	}

	public void warn_UserTransaction_jndifailure(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-16093 Failed to lookup user transaction in JNDI context", (Object)null);
	}

	public String get_utils_JNDIManager_tsr1() {
		return "ARJUNA-16096 Unable to instantiate TransactionSynchronizationRegistry implementation class!";
	}

	public String get_utils_nullexception() {
		return "ARJUNA-16098 Null exception!";
	}

	public String get_utils_unknownerrorcode() {
		return "ARJUNA-16099 Unknown error code:";
	}

	public String get_xa_xidunset() {
		return "ARJUNA-16100 Xid unset";
	}

	public String get_xid_packerror() {
		return "ARJUNA-16101 Could not pack XidImple.";
	}

}
