/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.logging.basic;

import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.internal.util.logging.commonPropertyManager;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BasicLog
implements Serializable,
LogInterface {
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    static PrintStream defaultLogFile = null;
    static String defaultFileName = null;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected String logName = null;
    protected int currentLogLevel;
    private String shortLogName = null;
    protected boolean showLogName = commonPropertyManager.getBasicLogEnvironmentBean().isShowLogName();
    protected boolean showShortName = commonPropertyManager.getBasicLogEnvironmentBean().isShowShortLogName();
    protected boolean showDateTime = commonPropertyManager.getBasicLogEnvironmentBean().isShowDate();
    protected String dateTimeFormat = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected DateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS zzz");

    private void initializeDefaultLog() {
        if (defaultLogFile != null) {
            return;
        }
        defaultFileName = commonPropertyManager.getBasicLogEnvironmentBean().getLogFile();
        boolean fileAppend = commonPropertyManager.getBasicLogEnvironmentBean().isLogFileAppend();
        try {
            if (defaultFileName == null) {
                defaultLogFile = System.out;
            } else {
                FileOutputStream fOut = new FileOutputStream(defaultFileName, fileAppend);
                defaultLogFile = new PrintStream(fOut, true);
            }
            defaultLogFile.println();
            defaultLogFile.println();
            defaultLogFile.println("---------------------------------------------------------------");
            defaultLogFile.println("DEFAULT LOG, started " + this.dateFormatter.format(new Date()));
            defaultLogFile.println("---------------------------------------------------------------");
        }
        catch (Exception e) {
            System.err.println("cannot set up default log for error messages to file " + defaultFileName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public BasicLog(String name) {
        this.logName = name;
        this.setLevel(3);
        String lvl = commonPropertyManager.getBasicLogEnvironmentBean().getLevel();
        if ("all".equalsIgnoreCase(lvl)) {
            this.setLevel(0);
        } else if ("trace".equalsIgnoreCase(lvl)) {
            this.setLevel(1);
        } else if ("debug".equalsIgnoreCase(lvl)) {
            this.setLevel(2);
        } else if ("info".equalsIgnoreCase(lvl)) {
            this.setLevel(3);
        } else if ("warn".equalsIgnoreCase(lvl)) {
            this.setLevel(4);
        } else if ("error".equalsIgnoreCase(lvl)) {
            this.setLevel(5);
        } else if ("fatal".equalsIgnoreCase(lvl)) {
            this.setLevel(6);
        } else if ("off".equalsIgnoreCase(lvl)) {
            this.setLevel(7);
        }
        this.initializeDefaultLog();
    }

    public void setLevel(int currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    protected void log(int type, Object message, Throwable t) {
        StringBuffer buf = new StringBuffer();
        if (this.showDateTime) {
            buf.append(this.dateFormatter.format(new Date()));
            buf.append(" ");
        }
        switch (type) {
            case 1: {
                buf.append("[TRACE] ");
                break;
            }
            case 2: {
                buf.append("[DEBUG] ");
                break;
            }
            case 3: {
                buf.append("[INFO] ");
                break;
            }
            case 4: {
                buf.append("[WARN] ");
                break;
            }
            case 5: {
                buf.append("[ERROR] ");
                break;
            }
            case 6: {
                buf.append("[FATAL] ");
            }
        }
        if (this.showShortName) {
            if (this.shortLogName == null) {
                this.shortLogName = this.logName.substring(this.logName.lastIndexOf(".") + 1);
                this.shortLogName = this.shortLogName.substring(this.shortLogName.lastIndexOf("/") + 1);
            }
            buf.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (this.showLogName) {
            buf.append(String.valueOf(this.logName)).append(" - ");
        }
        buf.append(String.valueOf(message));
        if (t != null) {
            buf.append(" <");
            buf.append(t.toString());
            buf.append(">");
            StringWriter sw = new StringWriter(1024);
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            buf.append(sw.toString());
        }
        this.write(buf);
    }

    protected void write(StringBuffer buffer) {
        defaultLogFile.println(buffer.toString());
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    @Override
    public final void debug(String message) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, null);
        }
    }

    @Override
    public final void debug(String message, Throwable t) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, t);
        }
    }

    @Override
    public final void trace(String message) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, null);
        }
    }

    @Override
    public final void trace(String message, Throwable t) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, t);
        }
    }

    @Override
    public final void info(String message) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, null);
        }
    }

    @Override
    public final void info(String message, Throwable t) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, t);
        }
    }

    @Override
    public final void warn(String message) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, null);
        }
    }

    @Override
    public final void warn(String message, Throwable t) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, t);
        }
    }

    @Override
    public final void error(String message) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, null);
        }
    }

    @Override
    public final void error(String message, Throwable t) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, t);
        }
    }

    @Override
    public final void fatal(String message) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, null);
        }
    }

    @Override
    public final void fatal(String message, Throwable t) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, t);
        }
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    @Override
    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    @Override
    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    @Override
    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    @Override
    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    @Override
    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }
}

