/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.logging;

import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.util.logging.Logi18n;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Logi18nImpl
implements Logi18n {
    private ResourceBundle m_resourceBundle = null;
    private final LogInterface m_logInterface;

    public Logi18nImpl(LogInterface logInterface, String resBundle) {
        this.m_logInterface = logInterface;
        this.addResourceBundle(resBundle);
    }

    private synchronized void addResourceBundle(String bundleName) {
        try {
            this.m_resourceBundle = PropertyResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException mre) {
            System.err.println("resource bundle " + mre.getClassName() + " not found!");
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_logInterface.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_logInterface.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_logInterface.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_logInterface.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.m_logInterface.isFatalEnabled();
    }

    @Override
    public String getString(String key) {
        try {
            return this.getResourceBundleString(key);
        }
        catch (MissingResourceException mre) {
            return mre.getLocalizedMessage() + ": [key='" + key + "']";
        }
    }

    @Override
    public String getString(String key, Object[] params) {
        try {
            String pattern = this.getResourceBundleString(key);
            return MessageFormat.format(pattern, params);
        }
        catch (MissingResourceException mre) {
            StringBuffer sb = new StringBuffer();
            for (Object param : params) {
                sb.append(param);
                sb.append(", ");
            }
            return mre.getLocalizedMessage() + ": [key='" + key + "']" + sb.toString();
        }
    }

    synchronized String getResourceBundleString(String key) throws MissingResourceException {
        String resource = null;
        if (this.m_resourceBundle == null) {
            throw new MissingResourceException("no resource bundle set for this logger", null, null);
        }
        resource = this.m_resourceBundle.getString(key);
        return resource;
    }

    @Override
    public void debug(String key) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.debug(message);
    }

    @Override
    public void debug(String key, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.debug(message, throwable);
    }

    @Override
    public void debug(String key, Object[] params) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.debug(message);
    }

    @Override
    public void debug(String key, Object[] params, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.debug(message, throwable);
    }

    @Override
    public void info(String key) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.info(message);
    }

    @Override
    public void info(String key, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.info(message, throwable);
    }

    @Override
    public void info(String key, Object[] params) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.info(message);
    }

    @Override
    public void info(String key, Object[] params, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.info(message, throwable);
    }

    @Override
    public void warn(String key) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.warn(message);
    }

    @Override
    public void warn(String key, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.warn(message, throwable);
    }

    @Override
    public void warn(String key, Object[] params) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.warn(message);
    }

    @Override
    public void warn(String key, Object[] params, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.warn(message, throwable);
    }

    @Override
    public void error(String key) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.error(message);
    }

    @Override
    public void error(String key, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.error(message, throwable);
    }

    @Override
    public void error(String key, Object[] params) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.error(message);
    }

    @Override
    public void error(String key, Object[] params, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.error(message, throwable);
    }

    @Override
    public void fatal(String key) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.fatal(message);
    }

    @Override
    public void fatal(String key, Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.fatal(message, throwable);
    }

    @Override
    public void fatal(String key, Object[] params) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.fatal(message);
    }

    @Override
    public void fatal(String key, Object[] params, Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.fatal(message, throwable);
    }

    protected String evalResourceBundle(String key) {
        return this.getString(key);
    }

    protected String evalResourceBundle(String key, Object[] params) {
        return this.getString(key, params);
    }
}

