/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.utils;

import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import javax.naming.ConfigurationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;

public class JNDIManager {
    public static void bindJTAImplementations(InitialContext ctx) throws NamingException {
        JNDIManager.bindJTATransactionManagerImplementation(ctx);
        JNDIManager.bindJTAUserTransactionImplementation(ctx);
        JNDIManager.bindJTATransactionSynchronizationRegistryImplementation(ctx);
    }

    public static void bindJTAImplementation() throws NamingException {
        JNDIManager.bindJTATransactionManagerImplementation();
        JNDIManager.bindJTAUserTransactionImplementation();
        JNDIManager.bindJTATransactionSynchronizationRegistryImplementation();
    }

    public static void bindJTATransactionManagerImplementation() throws NamingException {
        JNDIManager.bindJTATransactionManagerImplementation(new InitialContext());
    }

    public static void unbindJTATransactionManagerImplementation() throws NamingException {
        JNDIManager.unbindJTATransactionManagerImplementation(new InitialContext());
    }

    public static void bindJTATransactionManagerImplementation(InitialContext initialContext) throws NamingException {
        String tmImplementation = jtaPropertyManager.getJTAEnvironmentBean().getTransactionManagerClassName();
        Reference ref = new Reference(tmImplementation, tmImplementation, null);
        initialContext.rebind(JNDIManager.getTransactionManagerJNDIName(), (Object)ref);
    }

    public static void unbindJTATransactionManagerImplementation(InitialContext initialContext) throws NamingException {
        initialContext.unbind(JNDIManager.getTransactionManagerJNDIName());
    }

    public static void bindJTAUserTransactionImplementation() throws NamingException {
        JNDIManager.bindJTAUserTransactionImplementation(new InitialContext());
    }

    public static void bindJTAUserTransactionImplementation(InitialContext initialContext) throws NamingException {
        String utImplementation = jtaPropertyManager.getJTAEnvironmentBean().getUserTransactionClassName();
        Reference ref = new Reference(utImplementation, utImplementation, null);
        initialContext.rebind(JNDIManager.getUserTransactionJNDIName(), (Object)ref);
    }

    public static void bindJTATransactionSynchronizationRegistryImplementation() throws NamingException {
        JNDIManager.bindJTATransactionSynchronizationRegistryImplementation(new InitialContext());
    }

    public static void unbindJTATransactionSynchronizationRegistryImplementation() throws NamingException {
        JNDIManager.unbindJTATransactionSynchronizationRegistryImplementation(new InitialContext());
    }

    public static void bindJTATransactionSynchronizationRegistryImplementation(InitialContext initialContext) throws NamingException {
        String tsrImplementation = jtaPropertyManager.getJTAEnvironmentBean().getTransactionSynchronizationRegistryClassName();
        Object tsr = null;
        try {
            tsr = Class.forName(tsrImplementation).newInstance();
        }
        catch (Exception e) {
            ConfigurationException namingException = new ConfigurationException(jtaLogger.loggerI18N.getString("com.arjuna.ats.jta.utils.JNDIManager.tsr1"));
            namingException.setRootCause(e);
            throw namingException;
        }
        initialContext.rebind(JNDIManager.getTransactionSynchronizationRegistryJNDIName(), tsr);
    }

    public static void unbindJTATransactionSynchronizationRegistryImplementation(InitialContext initialContext) throws NamingException {
        initialContext.unbind(JNDIManager.getTransactionSynchronizationRegistryJNDIName());
    }

    private static final String getTransactionManagerJNDIName() {
        return jtaPropertyManager.getJTAEnvironmentBean().getTransactionManagerJNDIContext();
    }

    private static final String getUserTransactionJNDIName() {
        return jtaPropertyManager.getJTAEnvironmentBean().getUserTransactionJNDIContext();
    }

    private static final String getTransactionSynchronizationRegistryJNDIName() {
        return jtaPropertyManager.getJTAEnvironmentBean().getTransactionSynchronizationRegistryJNDIContext();
    }
}

