/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.abstractrecords;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreType;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.abstractrecords.CadaverRecord;
import com.arjuna.ats.internal.arjuna.abstractrecords.StateManagerFriend;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.io.PrintWriter;

public class DisposeRecord
extends CadaverRecord {
    private Uid objectUid;
    private String typeName;
    private ObjectStore store;

    public DisposeRecord(ObjectStore objStore, StateManager sm) {
        super(null, objStore, sm);
        this.store = objStore;
        if (sm != null) {
            this.objectUid = sm.get_uid();
            this.typeName = sm.type();
        } else {
            this.objectUid = Uid.nullUid();
            this.typeName = null;
        }
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("DisposeRecord::DisposeRecord(" + objStore + ", " + this.objectUid + ")");
        }
    }

    @Override
    public boolean propagateOnAbort() {
        return false;
    }

    @Override
    public int typeIs() {
        return 211;
    }

    @Override
    public int nestedAbort() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("DisposeRecord::nestedAbort() for " + this.order());
        }
        return 7;
    }

    @Override
    public int nestedCommit() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("DisposeRecord::nestedCommit() for " + this.order());
        }
        return 7;
    }

    @Override
    public int nestedPrepare() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("DisposeRecord::nestedPrepare() for " + this.order());
        }
        if (this.store != null && this.objectUid.notEquals(Uid.nullUid())) {
            return 0;
        }
        return 1;
    }

    @Override
    public int topLevelAbort() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("DisposeRecord::topLevelAbort() for " + this.order());
        }
        return 7;
    }

    @Override
    public int topLevelCommit() {
        block6: {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug("DisposeRecord::topLevelCommit() for " + this.order());
            }
            if (this.store != null && this.objectUid.notEquals(Uid.nullUid())) {
                try {
                    if (this.store.remove_committed(this.objectUid, this.typeName)) {
                        if (this.objectAddr != null) {
                            StateManagerFriend.destroyed(this.objectAddr);
                        }
                        return 7;
                    }
                }
                catch (Throwable e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block6;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_5", new Object[]{e});
                }
            }
        }
        return 8;
    }

    @Override
    public int topLevelPrepare() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("DisposeRecord::topLevelPrepare() for " + this.order());
        }
        if (this.store != null && this.objectUid.notEquals(Uid.nullUid())) {
            return 0;
        }
        return 1;
    }

    @Override
    public void print(PrintWriter strm) {
        strm.println("Dispose for:");
        super.print(strm);
    }

    @Override
    public boolean doSave() {
        return true;
    }

    @Override
    public boolean save_state(OutputObjectState os, int ot) {
        boolean res = true;
        if (this.store != null && this.objectUid.notEquals(Uid.nullUid())) {
            if (!ObjectStoreType.valid(this.store.typeIs())) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_1");
                }
                res = false;
            } else {
                try {
                    os.packInt(this.store.typeIs());
                    this.store.pack(os);
                    UidHelper.packInto(this.objectUid, os);
                    os.packString(this.typeName);
                }
                catch (IOException e) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_2");
                    }
                    res = false;
                }
            }
        } else {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_3");
            }
            res = false;
        }
        return res;
    }

    @Override
    public boolean restore_state(InputObjectState os, int ot) {
        boolean res = true;
        int objStoreType = 0;
        try {
            objStoreType = os.unpackInt();
            if (ObjectStoreType.valid(objStoreType)) {
                Class<? extends ObjectStore> osc = ObjectStoreType.typeToClass(objStoreType);
                this.store = osc.newInstance();
                this.store.unpack(os);
                this.objectUid = UidHelper.unpackFrom(os);
                this.typeName = os.unpackString();
            } else {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_4", new Object[]{Integer.toString(objStoreType)});
                }
                res = false;
            }
        }
        catch (Exception e) {
            res = false;
        }
        return res;
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord/CadaverRecord/DisposeRecord";
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public DisposeRecord() {
        this.objectUid = new Uid(Uid.nullUid());
        this.typeName = null;
        this.store = null;
    }
}

