/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.logging;

import com.arjuna.common.internal.util.logging.Logi18nInterface;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;

public final class JBossLogger
implements Logi18nInterface {
    private final Logger logger;
    private static final String FQCN = JBossLogger.class.getName();

    public JBossLogger(String categoryName) {
        this.logger = Logger.getLogger((String)categoryName);
    }

    public JBossLogger(String categoryName, String resourceBundleName) {
        this.logger = Logger.getLogger((String)categoryName, (String)resourceBundleName);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.FATAL);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.TRACE);
    }

    public void trace(String message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.TRACE, message, null);
    }

    public void trace(String message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.TRACE, message, t);
    }

    public void debug(String message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.DEBUG, message, null);
    }

    public void debug(String message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.DEBUG, message, t);
    }

    public void debug(String key, Object[] params) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.DEBUG, key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, null);
    }

    public void debug(String key, Object[] params, Throwable throwable) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.DEBUG, key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, throwable);
    }

    public void info(String message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.INFO, message, null);
    }

    public void info(String message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.INFO, message, t);
    }

    public void info(String key, Object[] params) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.INFO, key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, null);
    }

    public void info(String key, Object[] params, Throwable throwable) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.INFO, key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, throwable);
    }

    public void warn(String message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.WARN, message, null);
    }

    public void warn(String key, Object[] params) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.WARN, key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, null);
    }

    public void warn(String key, Object[] params, Throwable throwable) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.WARN, key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, throwable);
    }

    public void warn(String message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.WARN, message, t);
    }

    public void error(String message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.ERROR, message, null);
    }

    public void error(String message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.WARN, message, t);
    }

    public void error(String key, Object[] params) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.ERROR, key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, null);
    }

    public void error(String key, Object[] params, Throwable throwable) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.ERROR, key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, throwable);
    }

    public void fatal(String message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.FATAL, message, null);
    }

    public void fatal(String message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.FATAL, message, t);
    }

    public void fatal(String key, Object[] params) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.FATAL, key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, null);
    }

    public void fatal(String key, Object[] params, Throwable throwable) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.FATAL, key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, throwable);
    }
}

