/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.overview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.model.SelectItem;
import org.jboss.logging.Logger;
import org.jboss.overview.SingletonAider;
import org.jboss.overview.model.OverviewData;
import org.richfaces.application.push.MessageException;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.TopicsContext;
import org.richfaces.component.SortOrder;

@ManagedBean
@SessionScoped
public class DataTableScrollerBean
implements Serializable {
    private static final long serialVersionUID = 8201807342793317060L;
    private static final Logger LOGGER = Logger.getLogger(DataTableScrollerBean.class);
    private List<OverviewData> dataList = null;
    public String branchFilter;
    private SortOrder branchOrder = SortOrder.descending;
    private SortOrder pullRequestOrder = SortOrder.descending;
    private SortOrder buildResultOrder = SortOrder.descending;
    private SortOrder mergeableOrder = SortOrder.descending;
    private SortOrder isReviewedOrder = SortOrder.descending;
    private SortOrder pullStateOrder = SortOrder.descending;
    @EJB
    public SingletonAider aider;

    @PostConstruct
    public void postContruct() {
    }

    public List<OverviewData> getDataList() {
        this.dataList = new ArrayList(this.aider.getCache().values());
        Collections.sort(this.dataList, new /* Unavailable Anonymous Inner Class!! */);
        return this.dataList;
    }

    public List<SelectItem> getBranchOptions() {
        ArrayList<SelectItem> branchOptions = new ArrayList<SelectItem>();
        branchOptions.add(new SelectItem((Object)"", "All Branches"));
        for (String branch : this.aider.getHelper().getEvaluatorFacade().getCoveredBranches()) {
            branchOptions.add(new SelectItem((Object)branch));
        }
        return branchOptions;
    }

    public String getBranchFilter() {
        return this.branchFilter;
    }

    public void setBranchFilter(String branchFilter) {
        this.branchFilter = branchFilter;
    }

    public SortOrder getBranchOrder() {
        return this.branchOrder;
    }

    public SortOrder getPullRequestOrder() {
        return this.pullRequestOrder;
    }

    public SortOrder getBuildResultOrder() {
        return this.buildResultOrder;
    }

    public SortOrder getMergeableOrder() {
        return this.mergeableOrder;
    }

    public SortOrder getIsReviewedOrder() {
        return this.isReviewedOrder;
    }

    public SortOrder getPullStateOrder() {
        return this.pullStateOrder;
    }

    public void sortByBranch() {
        this.pullRequestOrder = SortOrder.unsorted;
        this.buildResultOrder = SortOrder.unsorted;
        this.mergeableOrder = SortOrder.unsorted;
        this.isReviewedOrder = SortOrder.unsorted;
        this.pullStateOrder = SortOrder.unsorted;
        LOGGER.debug((Object)("sortByBranch..." + this.branchOrder));
        this.branchOrder = this.branchOrder.equals((Object)SortOrder.descending) ? SortOrder.ascending : SortOrder.descending;
    }

    public void sortByPullRequest() {
        this.branchOrder = SortOrder.unsorted;
        this.buildResultOrder = SortOrder.unsorted;
        this.mergeableOrder = SortOrder.unsorted;
        this.isReviewedOrder = SortOrder.unsorted;
        this.pullStateOrder = SortOrder.unsorted;
        LOGGER.debug((Object)("sortByPullRequest..." + this.pullRequestOrder));
        this.pullRequestOrder = this.pullRequestOrder.equals((Object)SortOrder.descending) ? SortOrder.ascending : SortOrder.descending;
    }

    public void sortByBuildResult() {
        this.branchOrder = SortOrder.unsorted;
        this.pullRequestOrder = SortOrder.unsorted;
        this.mergeableOrder = SortOrder.unsorted;
        this.isReviewedOrder = SortOrder.unsorted;
        this.pullStateOrder = SortOrder.unsorted;
        LOGGER.debug((Object)("sortByBuildRequest..." + this.buildResultOrder));
        this.buildResultOrder = this.buildResultOrder.equals((Object)SortOrder.descending) ? SortOrder.ascending : SortOrder.descending;
    }

    public void sortByMergeable() {
        this.branchOrder = SortOrder.unsorted;
        this.pullRequestOrder = SortOrder.unsorted;
        this.buildResultOrder = SortOrder.unsorted;
        this.isReviewedOrder = SortOrder.unsorted;
        this.pullStateOrder = SortOrder.unsorted;
        LOGGER.debug((Object)("sortByMergeable..." + this.mergeableOrder));
        this.mergeableOrder = this.mergeableOrder.equals((Object)SortOrder.descending) ? SortOrder.ascending : SortOrder.descending;
    }

    public void sortByReviewed() {
        this.branchOrder = SortOrder.unsorted;
        this.pullRequestOrder = SortOrder.unsorted;
        this.buildResultOrder = SortOrder.unsorted;
        this.mergeableOrder = SortOrder.unsorted;
        this.pullStateOrder = SortOrder.unsorted;
        LOGGER.debug((Object)("sortByReviewed..." + this.isReviewedOrder));
        this.isReviewedOrder = this.isReviewedOrder.equals((Object)SortOrder.descending) ? SortOrder.ascending : SortOrder.descending;
    }

    public void sortByPullState() {
        this.branchOrder = SortOrder.unsorted;
        this.pullRequestOrder = SortOrder.unsorted;
        this.buildResultOrder = SortOrder.unsorted;
        this.mergeableOrder = SortOrder.unsorted;
        this.isReviewedOrder = SortOrder.unsorted;
        LOGGER.debug((Object)("sortByPullStateOrder..." + this.pullStateOrder));
        this.pullStateOrder = this.pullStateOrder.equals((Object)SortOrder.descending) ? SortOrder.ascending : SortOrder.descending;
    }

    public static void push() throws MessageException {
        TopicKey topicKey = new TopicKey("pushAddress");
        TopicsContext topicsContext = TopicsContext.lookup();
        topicsContext.publish(topicKey, (Object)"empty message");
    }
}

