/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.integration.deployer.env.bda.Archive;
import org.jboss.weld.integration.deployer.env.bda.ArchiveLifecycleListener;
import org.jboss.weld.integration.deployer.env.bda.Classpath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClasspathImpl
implements Classpath,
ArchiveLifecycleListener {
    private Collection<Archive> archives = new ArrayList<Archive>();
    private Classpath classpath;
    private final String name;

    public ClasspathImpl(String name, Archive ... archives) {
        this.name = name;
        for (Archive archive : archives) {
            this.archives.add(archive);
        }
    }

    public ClasspathImpl(String name, Classpath classpath, Archive ... archives) {
        this(name, archives);
        this.classpath = classpath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addArchive(Archive archive) {
        this.archives.add(archive);
        archive.addLifecycleListener(this);
    }

    @Override
    public Iterator<Archive> iterator() {
        return this.archives.iterator();
    }

    @Override
    public Classpath getClasspath() {
        return this.classpath;
    }

    @Override
    public Collection<BeanDeploymentArchive> getBDAs(BeanDeploymentArchive bda) {
        if (this.archives.isEmpty() && this.classpath != null) {
            return this.classpath.getBDAs(bda);
        }
        Collection<BeanDeploymentArchive> bdas = this.getBDAsFromArchives();
        if (bdas.isEmpty() && this.classpath != null) {
            return this.classpath.getBDAs(bda);
        }
        if (this.classpath != null) {
            bdas.addAll(this.classpath.getBDAs(bda));
        }
        return bdas;
    }

    public String toString() {
        return "Classpath[" + this.name + "]";
    }

    private Collection<BeanDeploymentArchive> getBDAsFromArchives() {
        ArrayList<BeanDeploymentArchive> bdas = new ArrayList<BeanDeploymentArchive>();
        for (Archive archive : this.archives) {
            BeanDeploymentArchive bda = archive.getBeanDeploymentArchive();
            if (bda == null) continue;
            bdas.add(bda);
        }
        return bdas;
    }

    @Override
    public void archiveVisible(Archive archive, BeanDeploymentArchive bda) {
    }

    @Override
    public void archiveDestroyed(Archive archive) {
        this.archives.remove(archive);
    }
}

