/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.integration.deployer.env.bda.Archive;
import org.jboss.weld.integration.deployer.env.bda.ArchiveFactory;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;
import org.jboss.weld.integration.deployer.env.bda.DeploymentImpl;
import org.jboss.weld.integration.deployer.env.bda.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArchiveLoader {
    private Map<Archive, Collection<DeploymentImpl>> loadedArchives = new HashMap<Archive, Collection<DeploymentImpl>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archive load(Class<?> beanClass, DeploymentImpl deployment) {
        ClassLoader beanClassLoader;
        ClassLoader classLoader = beanClassLoader = SecurityActions.getClassLoader(beanClass);
        synchronized (classLoader) {
            Archive archive = Archive.getInstance(beanClassLoader);
            if (archive == null) {
                ArchiveInfo archiveInfo = new ArchiveInfo(beanClassLoader);
                List<EjbDescriptor<?>> ejbs = Collections.emptyList();
                archive = ArchiveFactory.createArchive(archiveInfo, ejbs);
                this.registerArchiveLoadedByDeployment(archive, deployment);
            } else if (this.isLoaded(archive)) {
                this.registerArchiveReloadedByDeployment(archive, deployment);
            }
            return archive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unload(Archive archive, DeploymentImpl deployment) {
        if (!this.loadedArchives.containsKey(archive)) {
            return false;
        }
        ClassLoader classLoader = archive.getClassLoader();
        synchronized (classLoader) {
            Collection<DeploymentImpl> deployments = this.loadedArchives.get(archive);
            deployments.remove(deployment);
            if (deployments.isEmpty()) {
                this.loadedArchives.remove(archive);
                return true;
            }
            return false;
        }
    }

    private boolean isLoaded(Archive archive) {
        return this.loadedArchives.containsKey(archive);
    }

    private void registerArchiveReloadedByDeployment(Archive archive, DeploymentImpl deployment) {
        Collection<DeploymentImpl> deployments = this.loadedArchives.get(archive);
        deployments.add(deployment);
    }

    private void registerArchiveLoadedByDeployment(Archive archive, DeploymentImpl deployment) {
        HashSet<DeploymentImpl> deployments = new HashSet<DeploymentImpl>();
        deployments.add(deployment);
        this.loadedArchives.put(archive, deployments);
    }
}

