/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractOptionalVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.ext.JBossWeldMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldFilesDeployer
extends AbstractOptionalVFSRealDeployer<JBossWeldMetaData> {
    public WeldFilesDeployer() {
        super(JBossWeldMetaData.class);
        this.addOutput("WELD_FILES");
        this.addOutput("WELD_CLASSPATH");
        this.setStage(DeploymentStages.POST_PARSE);
    }

    public void deploy(VFSDeploymentUnit unit, JBossWeldMetaData deployment) throws DeploymentException {
        ArrayList<VirtualFile> wbFiles = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> cpFiles = new ArrayList<VirtualFile>();
        try {
            if (deployment != null) {
                // empty if block
            }
            Iterable<VirtualFile> classpaths = this.getClassPaths(unit);
            for (VirtualFile cp : classpaths) {
                VirtualFile wbXml = cp.getChild("META-INF/beans.xml");
                if (!wbXml.exists()) continue;
                wbFiles.add(wbXml);
                cpFiles.add(cp);
            }
            VirtualFile warWbXml = unit.getFile("WEB-INF/beans.xml");
            if (warWbXml != null) {
                wbFiles.add(warWbXml);
                VirtualFile classes = unit.getFile("WEB-INF/classes");
                if (classes != null) {
                    cpFiles.add(classes);
                }
            }
            if (!wbFiles.isEmpty()) {
                unit.addAttachment("WELD_FILES", wbFiles, Collection.class);
            }
            if (!cpFiles.isEmpty()) {
                unit.addAttachment("WELD_CLASSPATH", cpFiles, Collection.class);
            }
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot WBD files/classpath.", (Throwable)e);
        }
    }

    protected Iterable<VirtualFile> getClassPaths(VFSDeploymentUnit unit) throws Exception {
        List classpath = unit.getClassPath();
        if (classpath != null && !classpath.isEmpty()) {
            ArrayList<VirtualFile> matching = new ArrayList<VirtualFile>();
            VirtualFile root = unit.getRoot();
            Iterator i$ = classpath.iterator();
            while (i$.hasNext()) {
                VirtualFile cp;
                VirtualFile check;
                for (check = cp = (VirtualFile)i$.next(); check != null && !check.equals(root); check = check.getParent()) {
                }
                if (check == null) continue;
                matching.add(cp);
            }
            return matching;
        }
        return Collections.emptySet();
    }
}

